/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.dialogs;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.Messages;
import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportMergeOutputDialog
extends TrayDialog {
    private MergeOutput mergeOutput;
    private Button newTaskButton;
    private Button attachmentButton;
    private Button clipboardButton;
    private Button fileButton;
    private Text fileText;
    private Label attachmentDescriptionLabel;
    private Text attachmentDescriptionText;
    private Button browseButton;
    private Button okButton;
    private IDialogSettings settings;
    private int lastOutput;
    private int output;
    private String filePath;
    private String attachmentDescription;
    public static final int NEW_TASK = 0;
    public static final int ATTACHMENT = 1;
    public static final int CLIPBOARD = 2;
    public static final int FILESYSTEM = 3;
    private static final String LAST_OUTPUT = "ExportMergeOutputDialog.lastOutput";

    public ExportMergeOutputDialog(Shell shell, MergeOutput mergeOutput) {
        super(shell);
        this.mergeOutput = mergeOutput;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.settings = Activator.getDefault().getDialogSettings();
        try {
            this.lastOutput = this.settings.getInt(LAST_OUTPUT);
        }
        catch (Exception exception) {}
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ExportMergeOutputDialog_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group outputGroup = new Group(composite, 0);
        outputGroup.setText(Messages.ExportMergeOutputDialog_saveTo);
        GridLayout outputLayout = new GridLayout();
        outputLayout.numColumns = 3;
        outputGroup.setLayout((Layout)outputLayout);
        GridData data = new GridData(1808);
        outputGroup.setLayoutData((Object)data);
        this.clipboardButton = new Button((Composite)outputGroup, 16);
        this.clipboardButton.setText(Messages.ExportMergeOutputDialog_clipboard);
        data = new GridData();
        data.horizontalSpan = 3;
        this.clipboardButton.setLayoutData((Object)data);
        this.fileButton = new Button((Composite)outputGroup, 16);
        this.fileButton.setText(Messages.ExportMergeOutputDialog_fileSystem);
        this.fileText = new Text((Composite)outputGroup, 2048);
        data = new GridData(768);
        data.widthHint = 350;
        this.fileText.setLayoutData((Object)data);
        this.browseButton = new Button((Composite)outputGroup, 0);
        this.browseButton.setText(Messages.ExportMergeOutputDialog_browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog d = new FileDialog(ExportMergeOutputDialog.this.getShell(), 40960);
                d.setText(Messages.ExportMergeOutputDialog_saveAs);
                d.setFileName(String.valueOf(ExportMergeOutputDialog.this.mergeOutput.getResource().getName()) + ".mrg");
                String file = d.open();
                if (file != null) {
                    Path path = new Path(file);
                    ExportMergeOutputDialog.this.fileText.setText(path.toOSString());
                }
            }
        });
        if (this.lastOutput == 3) {
            this.fileText.setFocus();
        } else {
            this.fileText.setEnabled(false);
            this.browseButton.setEnabled(false);
        }
        this.newTaskButton = new Button((Composite)outputGroup, 16);
        this.newTaskButton.setText(Messages.ExportMergeOutputDialog_newTask);
        data = new GridData();
        data.horizontalSpan = 3;
        this.newTaskButton.setLayoutData((Object)data);
        this.attachmentButton = new Button((Composite)outputGroup, 16);
        this.attachmentButton.setText(Messages.ExportMergeOutputDialog_attach);
        data = new GridData();
        data.horizontalSpan = 3;
        this.attachmentButton.setLayoutData((Object)data);
        Composite attachmentGroup = new Composite((Composite)outputGroup, 0);
        GridLayout attachmentLayout = new GridLayout();
        attachmentLayout.numColumns = 2;
        attachmentGroup.setLayout((Layout)attachmentLayout);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        attachmentGroup.setLayoutData((Object)data);
        this.attachmentDescriptionLabel = new Label(attachmentGroup, 0);
        this.attachmentDescriptionLabel.setText(Messages.ExportMergeOutputDialog_attachmentDescription);
        this.attachmentDescriptionText = new Text(attachmentGroup, 2048);
        data = new GridData(768);
        data.widthHint = 300;
        this.attachmentDescriptionText.setLayoutData((Object)data);
        this.attachmentDescriptionText.setText(String.valueOf(this.mergeOutput.getResource().getName()) + ".mrg");
        if (this.lastOutput != 1) {
            this.attachmentDescriptionLabel.setEnabled(false);
            this.attachmentDescriptionText.setEnabled(false);
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportMergeOutputDialog.this.okButton.setEnabled(ExportMergeOutputDialog.this.canFinish());
            }
        };
        this.fileText.addModifyListener(modifyListener);
        this.attachmentDescriptionText.addModifyListener(modifyListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportMergeOutputDialog.this.newTaskButton.getSelection()) {
                    ExportMergeOutputDialog.this.settings.put(ExportMergeOutputDialog.LAST_OUTPUT, 0);
                } else if (ExportMergeOutputDialog.this.attachmentButton.getSelection()) {
                    ExportMergeOutputDialog.this.settings.put(ExportMergeOutputDialog.LAST_OUTPUT, 1);
                } else if (ExportMergeOutputDialog.this.fileButton.getSelection()) {
                    ExportMergeOutputDialog.this.settings.put(ExportMergeOutputDialog.LAST_OUTPUT, 3);
                } else {
                    ExportMergeOutputDialog.this.settings.put(ExportMergeOutputDialog.LAST_OUTPUT, 2);
                }
                ExportMergeOutputDialog.this.fileText.setEnabled(ExportMergeOutputDialog.this.fileButton.getSelection());
                if (e.getSource() == ExportMergeOutputDialog.this.fileButton && ExportMergeOutputDialog.this.fileButton.getSelection()) {
                    ExportMergeOutputDialog.this.fileText.setFocus();
                }
                if (e.getSource() == ExportMergeOutputDialog.this.attachmentButton && ExportMergeOutputDialog.this.attachmentButton.getSelection() && ExportMergeOutputDialog.this.attachmentDescriptionText.getText().trim().length() == 0) {
                    ExportMergeOutputDialog.this.attachmentDescriptionText.setFocus();
                }
                ExportMergeOutputDialog.this.browseButton.setEnabled(ExportMergeOutputDialog.this.fileButton.getSelection());
                ExportMergeOutputDialog.this.attachmentDescriptionLabel.setEnabled(ExportMergeOutputDialog.this.attachmentButton.getSelection());
                ExportMergeOutputDialog.this.attachmentDescriptionText.setEnabled(ExportMergeOutputDialog.this.attachmentButton.getSelection());
                ExportMergeOutputDialog.this.okButton.setEnabled(ExportMergeOutputDialog.this.canFinish());
            }
        };
        this.newTaskButton.addSelectionListener((SelectionListener)selectionListener);
        this.attachmentButton.addSelectionListener((SelectionListener)selectionListener);
        this.fileButton.addSelectionListener((SelectionListener)selectionListener);
        this.clipboardButton.addSelectionListener((SelectionListener)selectionListener);
        switch (this.lastOutput) {
            case 0: {
                this.newTaskButton.setSelection(true);
                break;
            }
            case 1: {
                this.attachmentButton.setSelection(true);
                break;
            }
            case 2: {
                this.clipboardButton.setSelection(true);
                break;
            }
            case 3: {
                this.fileButton.setSelection(true);
                break;
            }
            default: {
                this.clipboardButton.setSelection(true);
            }
        }
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fileText.addFocusListener((FocusListener)focusListener);
        this.attachmentDescriptionText.addFocusListener((FocusListener)focusListener);
        return composite;
    }

    protected void okPressed() {
        if (this.newTaskButton.getSelection()) {
            this.output = 0;
        } else if (this.attachmentButton.getSelection()) {
            this.output = 1;
            this.attachmentDescription = this.attachmentDescriptionText.getText().trim();
        } else if (this.clipboardButton.getSelection()) {
            this.output = 2;
        } else if (this.fileButton.getSelection()) {
            this.output = 3;
            this.filePath = this.fileText.getText().trim();
            File file = new File(this.filePath);
            if (file.exists()) {
                String title = Messages.ExportMergeOutputDialog_confirmOverwrite;
                String msg = Messages.ExportMergeOutputDialog_fileAlreadyExists;
                MessageDialog messageDialog = new MessageDialog(Display.getDefault().getActiveShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                if (messageDialog.open() != 0) {
                    return;
                }
            }
        }
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            if (this.lastOutput == 3) {
                this.okButton.setEnabled(false);
            }
        }
        return button;
    }

    private boolean canFinish() {
        if (this.fileButton.getSelection()) {
            if (this.fileText.getText().trim().length() == 0) {
                return false;
            }
            File file = new File(this.fileText.getText().trim());
            return this.isValidFile(file);
        }
        if (this.attachmentButton.getSelection()) {
            return this.attachmentDescriptionText.getText().trim().length() > 0;
        }
        return true;
    }

    private boolean isValidFile(File file) {
        if (!file.isAbsolute()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!parent.exists()) {
            return false;
        }
        return parent.isDirectory();
    }

    public int getOutput() {
        return this.output;
    }

    public File getFile() {
        return new File(this.filePath);
    }

    public String getAttachmentDescription() {
        return this.attachmentDescription;
    }
}

