/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards.mq;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.mq.Messages;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class QImportWizardPage
extends HgWizardPage {
    private Button revCheckBox;
    private ChangesetTable changesetTable;
    private ChangeSet[] revisions;
    private IResource resource;
    private Text patchFile;
    private Button browseButton;
    private Button forceCheckBox;
    private Button gitCheckBox;
    private Label patchFileLabel;
    private Group patchNameGroup;
    private boolean existing;

    public QImportWizardPage(String pageName, String title, String description, IResource resource, ImageDescriptor titleImage) {
        super(pageName, title, titleImage, description);
        this.resource = resource;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 3);
        this.createPatchNameGroup(composite);
        this.createOptionGroup(composite);
        this.createRevisionTable(composite);
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    private void createOptionGroup(Composite composite) {
        Group g = SWTWidgetHelper.createGroup(composite, Messages.getString("QImportWizardPage.optionsGroup.title"));
        this.forceCheckBox = SWTWidgetHelper.createCheckBox((Composite)g, Messages.getString("QImportWizardPage.forceCheckBox.title"));
        this.gitCheckBox = SWTWidgetHelper.createCheckBox((Composite)g, Messages.getString("QImportWizardPage.gitCheckBox.title"));
        this.gitCheckBox.setSelection(true);
    }

    private void createPatchNameGroup(Composite composite) {
        this.patchNameGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("QImportWizardPage.patchNameGroup.title"), 3, 768);
        this.patchFileLabel = SWTWidgetHelper.createLabel((Composite)this.patchNameGroup, Messages.getString("QImportWizardPage.patchFileLabel.title"));
        this.patchFile = SWTWidgetHelper.createTextField((Composite)this.patchNameGroup);
        this.patchFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (QImportWizardPage.this.patchFile.getText().length() > 0) {
                    try {
                        File file = new File(QImportWizardPage.this.patchFile.getText());
                        QImportWizardPage.this.checkExisting(file);
                    }
                    catch (Exception e1) {
                        QImportWizardPage.this.setErrorMessage(e1.getCause().getLocalizedMessage());
                    }
                }
            }
        });
        this.browseButton = SWTWidgetHelper.createPushButton((Composite)this.patchNameGroup, Messages.getString("QImportWizardPage.browseButton.title"), 1);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block3: {
                    try {
                        FileDialog dialog = new FileDialog(QImportWizardPage.this.getShell());
                        dialog.setText(Messages.getString("QImportWizardPage.browseFileDialog.title"));
                        String fileName = dialog.open();
                        if (fileName != null) {
                            File file = new File(fileName);
                            QImportWizardPage.this.checkExisting(file);
                            QImportWizardPage.this.patchFile.setText(file.getCanonicalPath());
                        }
                    }
                    catch (Exception e1) {
                        String msg = e1.getLocalizedMessage();
                        if (e1.getCause() == null) break block3;
                        msg = e1.getCause().getLocalizedMessage();
                        QImportWizardPage.this.setErrorMessage(msg);
                        MercurialEclipsePlugin.logError(e1);
                    }
                }
            }
        });
    }

    private void checkExisting(File file) throws IOException, HgException {
        this.setMessage(null);
        String hgRoot = HgRootClient.getHgRoot(this.resource);
        File patchDir = new File(String.valueOf(hgRoot) + File.separator + ".hg" + File.separator + "patches");
        File[] patches = patchDir.listFiles();
        if (patches != null) {
            File[] fileArray = patches;
            int n = patches.length;
            int n2 = 0;
            while (n2 < n) {
                File patch = fileArray[n2];
                if (patch.getCanonicalPath().equals(file.getCanonicalPath()) || patch.getName().equals(file.getName())) {
                    this.setMessage(Messages.getString("QImportWizardPage.message.Existing"));
                    this.existing = true;
                }
                ++n2;
            }
        }
    }

    private void createRevisionTable(Composite composite) {
        Group revGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("QImportWizardPage.revGroup.title"), 1808);
        this.revCheckBox = SWTWidgetHelper.createCheckBox((Composite)revGroup, Messages.getString("QImportWizardPage.revCheckBox.title"));
        Listener revCheckBoxListener = new Listener(){

            public void handleEvent(Event event) {
                if (QImportWizardPage.this.revCheckBox.getSelection() && (QImportWizardPage.this.changesetTable.getChangesets() == null || QImportWizardPage.this.changesetTable.getChangesets().length == 0)) {
                    QImportWizardPage.this.setErrorMessage(null);
                }
                QImportWizardPage.this.changesetTable.setEnabled(QImportWizardPage.this.revCheckBox.getSelection());
                QImportWizardPage.this.patchFile.setEnabled(!QImportWizardPage.this.revCheckBox.getSelection());
                QImportWizardPage.this.browseButton.setEnabled(!QImportWizardPage.this.revCheckBox.getSelection());
                QImportWizardPage.this.patchFileLabel.setEnabled(!QImportWizardPage.this.revCheckBox.getSelection());
                QImportWizardPage.this.patchNameGroup.setEnabled(!QImportWizardPage.this.revCheckBox.getSelection());
            }
        };
        this.revCheckBox.addListener(13, revCheckBoxListener);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.minimumHeight = 50;
        this.changesetTable = new ChangesetTable((Composite)revGroup, 68354, this.resource);
        this.changesetTable.setLayoutData(gridData);
        this.changesetTable.setEnabled(false);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QImportWizardPage.this.setPageComplete(true);
                QImportWizardPage.this.revisions = QImportWizardPage.this.changesetTable.getSelections();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.changesetTable.addSelectionListener(listener);
    }

    public boolean finish(IProgressMonitor monitor) {
        return super.finish(monitor);
    }

    public ChangeSet[] getRevisions() {
        return this.revisions;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public Button getRevCheckBox() {
        return this.revCheckBox;
    }

    public Text getPatchFile() {
        return this.patchFile;
    }

    public Button getForceCheckBox() {
        return this.forceCheckBox;
    }

    public Button getGitCheckBox() {
        return this.gitCheckBox;
    }

    public boolean isExisting() {
        return this.existing;
    }
}

