/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgBackoutClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BackoutWizardPage
extends HgWizardPage {
    private ChangesetTable changesetTable;
    private Text messageTextField;
    private Button mergeCheckBox;
    protected ChangeSet backoutRevision;
    private IProject project;
    private Text userTextField;

    public BackoutWizardPage(String pageName, String title, ImageDescriptor image, IProject project) {
        super(pageName, title, image);
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        Group changeSetGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("BackoutWizardPage.changeSetGroup.title"), 1808);
        this.changesetTable = new ChangesetTable((Composite)changeSetGroup, (IResource)this.project);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.minimumHeight = 50;
        this.changesetTable.setLayoutData(gridData);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BackoutWizardPage.this.backoutRevision = BackoutWizardPage.this.changesetTable.getSelection();
                BackoutWizardPage.this.messageTextField.setText(Messages.getString("BackoutWizardPage.defaultCommitMessage").concat(BackoutWizardPage.this.backoutRevision.toString()));
                BackoutWizardPage.this.setPageComplete(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.changesetTable.addSelectionListener(listener);
        this.changesetTable.setEnabled(true);
        Group optionGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("BackoutWizardPage.optionGroup.title"));
        SWTWidgetHelper.createLabel((Composite)optionGroup, Messages.getString("BackoutWizardPage.userLabel.text"));
        this.userTextField = SWTWidgetHelper.createTextField((Composite)optionGroup);
        this.userTextField.setText(MercurialUtilities.getHGUsername());
        SWTWidgetHelper.createLabel((Composite)optionGroup, Messages.getString("BackoutWizardPage.commitLabel.text"));
        this.messageTextField = SWTWidgetHelper.createTextField((Composite)optionGroup);
        this.mergeCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("BackoutWizardPage.mergeCheckBox.text"));
        this.mergeCheckBox.setSelection(true);
        this.setControl((Control)composite);
    }

    public boolean finish(IProgressMonitor monitor) {
        String msg = this.messageTextField.getText();
        boolean merge = this.mergeCheckBox.getSelection();
        this.backoutRevision = this.changesetTable.getSelection();
        try {
            String result = HgBackoutClient.backout(this.project, this.backoutRevision, merge, msg, this.userTextField.getText());
            HgClients.getConsole().printMessage(result, null);
        }
        catch (HgException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("BackoutWizardPage.backoutError"), (String)e.getMessage());
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            return false;
        }
        return true;
    }
}

