/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.compare.HgCompareEditorInput;
import com.vectrace.MercurialEclipse.compare.RevisionNode;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.IStorageMercurialRevision;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;

public class CompareUtils {
    public static void openEditor(IResource file, ChangeSet changeset, boolean dialog, boolean localEditable) {
        CompareUtils.openEditor(file, new IStorageMercurialRevision(file, String.valueOf(changeset.getChangesetIndex()), changeset.getChangeset(), changeset), dialog, localEditable);
    }

    public static void openEditor(IResource file, ChangeSet changeset, boolean localEditable) {
        CompareUtils.openEditor(file, new IStorageMercurialRevision(file, String.valueOf(changeset.getChangesetIndex()), changeset.getChangeset(), changeset), false, localEditable);
    }

    public static void openEditor(IResource file, IStorageMercurialRevision right, boolean dialog, boolean localEditable) {
        ResourceNode leftNode = null;
        if (file != null) {
            leftNode = new ResourceNode(file);
        }
        CompareUtils.openEditor(leftNode, CompareUtils.getNode(right), dialog, localEditable);
    }

    public static void openEditor(IStorageMercurialRevision left, IStorageMercurialRevision right, boolean dialog, boolean localEditable) {
        RevisionNode leftNode;
        RevisionNode rightNode;
        if (right == null) {
            rightNode = CompareUtils.getNode(left);
            leftNode = new ResourceNode(rightNode.getResource());
        } else {
            leftNode = CompareUtils.getNode(left);
            rightNode = CompareUtils.getNode(right);
        }
        CompareUtils.openEditor(leftNode, rightNode, dialog, localEditable);
    }

    public static void openEditor(ResourceNode left, ResourceNode right, boolean dialog, boolean localEditable) {
        Assert.isNotNull((Object)right);
        if (dialog) {
            CompareUtils.openCompareDialog(left, right, localEditable);
        } else {
            CompareEditorInput compareInput = CompareUtils.getCompareInput(left, right, localEditable);
            if (compareInput != null) {
                CompareUI.openCompareEditor((CompareEditorInput)compareInput);
            }
        }
    }

    public static int openCompareDialog(ResourceNode left, ResourceNode right, boolean localEditable) {
        CompareEditorInput compareInput = CompareUtils.getCompareInput(left, right, localEditable);
        return CompareUtils.openCompareDialog(compareInput);
    }

    public static int openCompareDialog(CompareEditorInput compareInput) {
        CompareUI.openCompareDialog((CompareEditorInput)compareInput);
        return 1;
    }

    public static CompareEditorInput getCompareInput(ResourceNode left, ResourceNode right, boolean localEditable) {
        IResource resource = right.getResource();
        ResourceNode leftNode = left != null ? left : right;
        ResourceNode rightNode = left != null ? right : new ResourceNode(resource);
        return new HgCompareEditorInput(new CompareConfiguration(), resource, leftNode, rightNode);
    }

    private static RevisionNode getNode(IStorageMercurialRevision rev) {
        return rev == null ? null : new RevisionNode(rev);
    }
}

