/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.utils.ClipboardUtils;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class LocationChooser
extends Composite
implements Listener {
    private Button btnClipboard;
    private Button btnFilesystem;
    private Text txtSystemFile;
    private Button btnBrowseFileSystem;
    private Button btnWorkspace;
    private Text txtWorkspaceFile;
    private Button btnBrowseWorkspace;
    private final boolean save;
    private ListenerList stateListeners = new ListenerList();
    private IDialogSettings settings;

    public LocationChooser(Composite parent, boolean save, IDialogSettings settings) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.createLocationControl();
        this.save = save;
        this.settings = settings;
        this.restoreSettings();
    }

    protected void createLocationControl() {
        this.btnClipboard = SWTWidgetHelper.createRadioButton(this, Messages.getString("ExportWizard.Clipboard"), 3);
        this.btnClipboard.addListener(13, (Listener)this);
        this.btnFilesystem = SWTWidgetHelper.createRadioButton(this, Messages.getString("ExportWizard.FileSystem"), 1);
        this.btnFilesystem.addListener(13, (Listener)this);
        this.txtSystemFile = SWTWidgetHelper.createTextField(this);
        this.txtSystemFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocationChooser.this.fireStateChanged();
            }
        });
        this.txtSystemFile.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }
        });
        this.btnBrowseFileSystem = SWTWidgetHelper.createPushButton(this, "...", 1);
        this.btnBrowseFileSystem.addListener(13, (Listener)this);
        this.btnWorkspace = SWTWidgetHelper.createRadioButton(this, Messages.getString("ExportWizard.Workspace"), 1);
        this.btnWorkspace.addListener(13, (Listener)this);
        this.txtWorkspaceFile = SWTWidgetHelper.createTextField(this);
        this.txtWorkspaceFile.setEditable(false);
        this.btnBrowseWorkspace = SWTWidgetHelper.createPushButton(this, "...", 1);
        this.btnBrowseWorkspace.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btnBrowseFileSystem) {
            FileDialog dialog = new FileDialog(this.getDisplay().getActiveShell(), 0x8000 | (this.save ? 8192 : 4096));
            dialog.setFileName(this.txtSystemFile.getText());
            String file = dialog.open();
            if (file != null) {
                this.txtSystemFile.setText(new Path(file).toOSString());
            }
        } else if (event.widget == this.btnBrowseWorkspace) {
            if (this.save) {
                SaveAsDialog dialog = new SaveAsDialog(this.getDisplay().getActiveShell());
                dialog.setOriginalFile(this.getWorkspaceFile());
                if (dialog.open() == 0) {
                    this.txtWorkspaceFile.setText(dialog.getResult().toString());
                }
            } else {
                ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(this.txtWorkspaceFile.getText());
                dialog.setInitialElementSelections(list);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null && result.length > 0) {
                    this.txtWorkspaceFile.setText(((IFile)result[0]).getFullPath().toPortableString());
                }
            }
        } else if (event.widget == this.btnClipboard || event.widget == this.btnFilesystem || event.widget == this.btnWorkspace) {
            this.updateBtnStatus();
        }
        this.fireStateChanged();
    }

    public String validate() {
        boolean valid = false;
        LocationType type = this.getLocationType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case FileSystem: 
            case Workspace: {
                valid = this.isValidSystemFile(this.getPatchFile());
                break;
            }
            case Clipboard: {
                return this.validateClipboard();
            }
        }
        if (valid) {
            return null;
        }
        return Messages.getString("ExportWizard.InvalidFileName");
    }

    private String validateClipboard() {
        if (this.save) {
            return null;
        }
        return ClipboardUtils.isEmpty() ? Messages.getString("LocationChooser.clipboardEmpty") : null;
    }

    private boolean isValidSystemFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isAbsolute()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (this.save) {
            File parent = file.getParentFile();
            if (parent == null) {
                return false;
            }
            if (!parent.exists()) {
                return false;
            }
            if (!parent.isDirectory()) {
                return false;
            }
        } else if (!file.exists()) {
            return false;
        }
        return true;
    }

    public File getPatchFile() {
        switch (this.getLocationType()) {
            case FileSystem: {
                return this.btnFilesystem.getSelection() ? new File(this.txtSystemFile.getText()) : null;
            }
            case Clipboard: {
                return null;
            }
            case Workspace: {
                IFile file = this.getWorkspaceFile();
                return file == null ? null : file.getLocation().toFile();
            }
        }
        return null;
    }

    public IFile getWorkspaceFile() {
        if (!this.btnWorkspace.getSelection() || this.txtWorkspaceFile.getText() == null || this.txtWorkspaceFile.getText().length() == 0) {
            return null;
        }
        Path parentToWorkspace = new Path(this.txtWorkspaceFile.getText());
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)parentToWorkspace);
    }

    public LocationType getLocationType() {
        if (this.btnClipboard.getSelection()) {
            return LocationType.Clipboard;
        }
        if (this.btnFilesystem.getSelection()) {
            return LocationType.FileSystem;
        }
        if (this.btnWorkspace.getSelection()) {
            return LocationType.Workspace;
        }
        return null;
    }

    private void updateBtnStatus() {
        LocationType type = this.getLocationType();
        this.txtSystemFile.setEnabled(type == LocationType.FileSystem);
        this.btnBrowseFileSystem.setEnabled(type == LocationType.FileSystem);
        this.btnBrowseWorkspace.setEnabled(type == LocationType.Workspace);
    }

    public void addStateListener(Listener listener) {
        this.stateListeners.add((Object)listener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ((Listener)obj).handleEvent(null);
            ++n2;
        }
    }

    public Location getCheckedLocation() {
        return new Location(this.getLocationType(), this.getPatchFile(), this.getWorkspaceFile());
    }

    protected void restoreSettings() {
        if (this.settings == null) {
            return;
        }
        String val = this.settings.get("LocationType");
        if (val != null) {
            this.setLocationType(LocationType.valueOf(val));
        }
    }

    public void saveSettings() {
        if (this.settings == null) {
            return;
        }
        this.settings.put("LocationType", this.getLocationType().name());
    }

    private void setLocationType(LocationType type) {
        switch (type) {
            case Clipboard: {
                this.btnClipboard.setSelection(true);
                break;
            }
            case FileSystem: {
                this.btnFilesystem.setSelection(true);
                break;
            }
            case Workspace: {
                this.btnWorkspace.setSelection(true);
            }
        }
        this.updateBtnStatus();
    }

    public static class Location {
        private final LocationType locationType;
        private final File file;
        private final IFile workspaceFile;

        public LocationType getLocationType() {
            return this.locationType;
        }

        public File getFile() {
            return this.file;
        }

        public IFile getWorkspaceFile() {
            return this.workspaceFile;
        }

        public Location(LocationType locationType, File file, IFile workspaceFile) {
            this.locationType = locationType;
            this.file = file;
            this.workspaceFile = workspaceFile;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationType {
        Clipboard,
        FileSystem,
        Workspace;

    }
}

