/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.storage;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class HgCommitMessageManager
extends DefaultHandler {
    private static List<String> commitMessages = new ArrayList<String>();
    private static final String COMMIT_MESSAGE_FILE = "commit_messages.xml";
    private static final String XML_TAG_COMMIT_MESSAGE = "commitmessage";
    private static final String XML_TAG_COMMIT_MESSAGES = "commitmessages";
    String tmpMessage;

    public void saveCommitMessage(String message) {
        if (commitMessages.contains(message)) {
            commitMessages.remove(message);
            commitMessages.add(0, message);
            return;
        }
        commitMessages.add(0, message);
        this.restrictSavedCommitMessages();
    }

    private void restrictSavedCommitMessages() {
        int prefs_commit_message_size_max = Integer.parseInt(MercurialUtilities.getPreference("hg.batchsize.commitmessage", "10"));
        while (commitMessages.size() > prefs_commit_message_size_max) {
            commitMessages.remove(commitMessages.size() - 1);
        }
    }

    private void addCommitMessage(String message) {
        commitMessages.add(message);
        this.restrictSavedCommitMessages();
    }

    public String[] getCommitMessages() {
        this.restrictSavedCommitMessages();
        return commitMessages.toArray(new String[0]);
    }

    private File getLocationFile() {
        return MercurialEclipsePlugin.getDefault().getStateLocation().append(COMMIT_MESSAGE_FILE).toFile();
    }

    public void start() throws IOException, HgException {
        File file = this.getLocationFile();
        if (file.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            try {
                SAXParser parser = parserFactory.newSAXParser();
                parser.parse(new InputSource(reader), (DefaultHandler)this);
            }
            catch (SAXException e) {
                MercurialEclipsePlugin.logError(e);
            }
            catch (ParserConfigurationException e) {
                MercurialEclipsePlugin.logError(e);
            }
            reader.close();
        }
    }

    public void stop() throws IOException {
        File file = this.getLocationFile();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        StreamResult streamResult = new StreamResult(writer);
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("indent", "yes");
            transformerHandler.setResult(streamResult);
            transformerHandler.startDocument();
            AttributesImpl atts = new AttributesImpl();
            atts.clear();
            transformerHandler.startElement("", "", XML_TAG_COMMIT_MESSAGES, atts);
            int size = commitMessages.size();
            int prefs_commit_message_size_max = Integer.parseInt(MercurialUtilities.getPreference("hg.batchsize.commitmessage", "10"));
            if (size > prefs_commit_message_size_max) {
                size = prefs_commit_message_size_max;
            }
            int i = 0;
            while (i < size) {
                String msg = commitMessages.get(i);
                transformerHandler.startElement("", "", XML_TAG_COMMIT_MESSAGE, atts);
                transformerHandler.characters(msg.toCharArray(), 0, msg.length());
                transformerHandler.endElement("", "", XML_TAG_COMMIT_MESSAGE);
                ++i;
            }
            transformerHandler.endElement("", "", XML_TAG_COMMIT_MESSAGES);
            transformerHandler.endDocument();
        }
        catch (TransformerConfigurationException e) {
            MercurialEclipsePlugin.logError(e);
        }
        catch (IllegalArgumentException e) {
            MercurialEclipsePlugin.logError(e);
        }
        catch (SAXException e) {
            MercurialEclipsePlugin.logError(e);
        }
        writer.close();
    }

    public void startElement(String uri, String localName, String qname, Attributes attr) {
        this.tmpMessage = "";
    }

    public void endElement(String uri, String localName, String qname) {
        if (qname.equalsIgnoreCase(XML_TAG_COMMIT_MESSAGE)) {
            this.addCommitMessage(this.tmpMessage);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.tmpMessage = String.valueOf(this.tmpMessage) + new String(ch, start, length);
    }
}

