/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.repository;

import com.vectrace.MercurialEclipse.repository.IRepositoryListener;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.util.ArrayList;
import java.util.List;

public class RepositoryResourcesManager {
    private static RepositoryResourcesManager instance;
    private List<IRepositoryListener> repositoryListeners = new ArrayList<IRepositoryListener>();

    private RepositoryResourcesManager() {
    }

    public static RepositoryResourcesManager getInstance() {
        if (instance == null) {
            instance = new RepositoryResourcesManager();
        }
        return instance;
    }

    public void addRepositoryListener(IRepositoryListener listener) {
        this.repositoryListeners.add(listener);
    }

    public void removeRepositoryListener(IRepositoryListener listener) {
        this.repositoryListeners.remove(listener);
    }

    public void repositoryRemoved(HgRepositoryLocation repository) {
        for (IRepositoryListener listener : this.repositoryListeners) {
            listener.repositoryRemoved(repository);
        }
    }

    public void repositoryAdded(HgRepositoryLocation repository) {
        for (IRepositoryListener listener : this.repositoryListeners) {
            listener.repositoryAdded(repository);
        }
    }

    public void repositoryModified(HgRepositoryLocation repository) {
        for (IRepositoryListener listener : this.repositoryListeners) {
            listener.repositoryModified(repository);
        }
    }
}

