/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.preferences;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.preferences.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ConsolePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor commandColorEditor;
    private ColorFieldEditor messageColorEditor;
    private ColorFieldEditor errorColorEditor;
    private BooleanFieldEditor showOnMessage;
    private BooleanFieldEditor restrictOutput;
    private BooleanFieldEditor wrap;
    private IntegerFieldEditor highWaterMark;
    private IntegerFieldEditor width;
    private BooleanFieldEditor debug;

    public ConsolePreferencesPage() {
        super(1);
        this.setPreferenceStore(MercurialEclipsePlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        this.createLabel(composite, Messages.getString("ConsolePreferencesPage.header"));
        IPreferenceStore store = this.getPreferenceStore();
        this.wrap = new BooleanFieldEditor("hg.console.wrap", Messages.getString("ConsolePreferencesPage.wrapText"), composite);
        this.addField((FieldEditor)this.wrap);
        this.width = new IntegerFieldEditor("hg.console.width", Messages.getString("ConsolePreferencesPage.consoleWidth"), composite);
        this.addField((FieldEditor)this.width);
        this.restrictOutput = new BooleanFieldEditor("hg.console.limitOutput", Messages.getString("ConsolePreferencesPage.limitOutput"), composite);
        this.addField((FieldEditor)this.restrictOutput);
        this.highWaterMark = new IntegerFieldEditor("hg.console.highWaterMark", Messages.getString("ConsolePreferencesPage.numberChars"), composite);
        this.addField((FieldEditor)this.highWaterMark);
        this.showOnMessage = new BooleanFieldEditor("hg.console.showOnMessage", Messages.getString("ConsolePreferencesPage.showConsoleOnMsg"), composite);
        this.addField((FieldEditor)this.showOnMessage);
        this.debug = new BooleanFieldEditor("hg.console.debug", Messages.getString("ConsolePreferencesPage.showAllHgMsg"), composite);
        this.addField((FieldEditor)this.debug);
        this.createLabel(composite, Messages.getString("ConsolePreferencesPage.colorPrefs"));
        this.commandColorEditor = this.createColorFieldEditor("hg.console.command_color", Messages.getString("ConsolePreferencesPage.cmdColor"), composite);
        this.addField((FieldEditor)this.commandColorEditor);
        this.messageColorEditor = this.createColorFieldEditor("hg.console.message_color", Messages.getString("ConsolePreferencesPage.msgColor"), composite);
        this.addField((FieldEditor)this.messageColorEditor);
        this.errorColorEditor = this.createColorFieldEditor("hg.console.error_color", Messages.getString("ConsolePreferencesPage.errorColor"), composite);
        this.addField((FieldEditor)this.errorColorEditor);
        this.width.setEnabled(store.getBoolean("hg.console.wrap"), composite);
        this.highWaterMark.setEnabled(store.getBoolean("hg.console.limitOutput"), composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.initIntegerFields();
        this.highWaterMark.setEnabled(this.restrictOutput.getBooleanValue(), this.getFieldEditorParent());
        this.width.setEnabled(this.wrap.getBooleanValue(), this.getFieldEditorParent());
    }

    private void initIntegerFields() {
        int currWidth;
        int currWatermark = this.highWaterMark.getIntValue();
        if (currWatermark < 1000) {
            this.highWaterMark.setValidRange(1000, 0x7FFFFFFE);
            this.highWaterMark.setStringValue("1000");
        }
        if ((currWidth = this.width.getIntValue()) < 80) {
            this.width.setStringValue("80");
            this.width.setValidRange(80, 0x7FFFFFFE);
        }
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        MercurialEclipsePlugin.getDefault().savePluginPreferences();
        return ok;
    }
}

