/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.commands.HgParentClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Ancestor {
    private HgRoot root;
    private ChangeSet cs1;
    private ChangeSet cs2;
    private ChangeSet ancestor;
    private static final Map<String, ChangeSet> CACHE = new HashMap<String, ChangeSet>();

    public Ancestor(HgRoot root, ChangeSet cs1, ChangeSet cs2) {
        assert (cs1 != null || cs2 != null);
        this.root = root;
        if (cs1 != null && cs2 != null && cs1.getChangesetIndex() < cs2.getChangesetIndex()) {
            this.cs1 = cs1;
            this.cs2 = cs2;
        } else {
            this.cs1 = cs2;
            this.cs2 = cs1;
        }
    }

    public ChangeSet get() throws HgException {
        if (this.ancestor == null) {
            if (this.cs1 != null && this.cs2 != null) {
                this.ancestor = CACHE.get(this.getKey());
                if (this.ancestor == null) {
                    int ancestorIndex = HgParentClient.findCommonAncestor((File)this.root, this.cs1, this.cs2);
                    this.ancestor = LocalChangesetCache.getInstance().getLocalChangeSet(MercurialUtilities.convert(this.root), String.valueOf(ancestorIndex));
                    CACHE.put(this.getKey(), this.ancestor);
                }
            } else {
                this.ancestor = this.cs1 != null ? this.cs1 : this.cs2;
            }
        }
        return this.ancestor;
    }

    private String getKey() {
        return String.valueOf(this.cs1.getChangeset()) + "|" + this.cs2.getChangeset();
    }
}

