/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.history;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.history.MercurialHistoryPage;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.model.GChangeSet;
import com.vectrace.MercurialEclipse.model.Signature;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class GraphLogTableViewer
extends TableViewer {
    private List<Color> colours = new ArrayList<Color>();
    private MercurialHistoryPage mhp;

    public GraphLogTableViewer(Composite parent, int style, MercurialHistoryPage mercurialHistoryPage) {
        super(parent, style);
        this.mhp = mercurialHistoryPage;
        this.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                GraphLogTableViewer.this.paint(event);
            }
        });
        Display display = parent.getDisplay();
        this.colours.add(display.getSystemColor(5));
        this.colours.add(display.getSystemColor(9));
        this.colours.add(display.getSystemColor(3));
        this.colours.add(display.getSystemColor(11));
        this.colours.add(display.getSystemColor(15));
        this.colours.add(display.getSystemColor(8));
        this.colours.add(display.getSystemColor(12));
        this.colours.add(display.getSystemColor(14));
    }

    protected void paint(Event event) {
        Signature sig;
        TableItem tableItem = (TableItem)event.item;
        if (event.index != 0) {
            return;
        }
        MercurialRevision rev = (MercurialRevision)((Object)tableItem.getData());
        GChangeSet gcs = rev.getGChangeSet();
        if (gcs != null) {
            this.paint(event, gcs.getBefore(), 0);
            this.paint(event, gcs.getMiddle(), 1);
            this.paint(event, gcs.getAfter(), 2);
        }
        Table table = tableItem.getParent();
        int from = rev.getChangeSet().getChangesetIndex() - 1;
        if (tableItem.equals(table.getItems()[table.getItemCount() - 1]) && from != this.mhp.getMercurialHistory().getBottom() && from >= 0) {
            MercurialHistoryPage mercurialHistoryPage = this.mhp;
            ((Object)((Object)mercurialHistoryPage)).getClass();
            MercurialHistoryPage.RefreshMercurialHistory refreshJob = new MercurialHistoryPage.RefreshMercurialHistory(mercurialHistoryPage, from, this.mhp.getMercurialHistory());
            refreshJob.schedule();
            try {
                refreshJob.join();
            }
            catch (InterruptedException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        if ((sig = rev.getSignature()) != null) {
            try {
                if (sig.validate()) {
                    tableItem.setBackground(this.colours.get(0));
                } else {
                    tableItem.setBackground(this.colours.get(2));
                }
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
            }
        }
    }

    private void paint(Event event, GChangeSet.EdgeList edges, int i) {
        GC g = event.gc;
        g.setLineAttributes(new LineAttributes(2.0f));
        g.setLineStyle(1);
        int div3 = event.height / 3;
        int y = event.y + div3 * i;
        int middle = event.y + event.height / 2;
        for (GChangeSet.Edge e : edges.getEdges()) {
            this.drawLine(event, g, div3, e.isFinish() ? middle : y, e, e.getTop(), e.getBottom());
            if (!e.isDot()) continue;
            this.fillOval(event, e);
        }
        int[] jump = edges.getJump();
        if (jump != null) {
            g.setLineStyle(3);
            g.setForeground(g.getDevice().getSystemColor(2));
            g.drawLine(this.getX(event, jump[0]), middle, this.getX(event, jump[1]), middle);
        }
    }

    private void drawLine(Event event, GC g, int div3, int y, GChangeSet.Edge e, int top, int bottom) {
        g.setForeground(this.getColor(event, e));
        g.drawLine(this.getX(event, top), y, this.getX(event, bottom), y + div3);
    }

    private void fillOval(Event event, GChangeSet.Edge e) {
        int size = 6;
        event.gc.setBackground(event.display.getSystemColor(2));
        int halfSize = size / 2;
        int i = e.getTop();
        if (e.isPlus()) {
            event.gc.drawOval(this.getX(event, i) - halfSize, event.y + event.height / 2 - halfSize, size, size);
        } else {
            event.gc.fillOval(this.getX(event, i) - halfSize, event.y + event.height / 2 - halfSize, size, size);
        }
    }

    private Color getColor(Event event, GChangeSet.Edge edge) {
        return this.colours.get(edge.getLane() % this.colours.size());
    }

    private int getX(Event event, int col) {
        return event.x + 8 * col + 5;
    }
}

