/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.io.File;

public class HgSvnClient
extends AbstractClient {
    public static String pull(File currentWorkingDirectory) throws HgException {
        HgCommand cmd = new HgCommand("svn", HgSvnClient.getWorkingDirectory(currentWorkingDirectory), false);
        cmd.setUsePreferenceTimeout("hg.timeout.pull");
        cmd.addOptions("pull");
        return cmd.executeToString();
    }

    public static String push(File currentWorkingDirectory) throws HgException {
        HgCommand cmd = new HgCommand("svn", HgSvnClient.getWorkingDirectory(currentWorkingDirectory), false);
        cmd.setUsePreferenceTimeout("hg.timeout.push");
        cmd.addOptions("push");
        return cmd.executeToString();
    }

    public static String rebase(File currentWorkingDirectory) throws HgException {
        HgCommand cmd = new HgCommand("svn", HgSvnClient.getWorkingDirectory(currentWorkingDirectory), false);
        cmd.setUsePreferenceTimeout("hg.timeout.push");
        cmd.addOptions("--config", "extensions.hgext.rebase=");
        cmd.addOptions("rebase");
        return cmd.executeToString();
    }

    public static void clone(File currentWorkingDirectory, HgRepositoryLocation repo, boolean timeout, String cloneName) throws HgException {
        HgCommand cmd = new HgCommand("svnclone", HgSvnClient.getWorkingDirectory(currentWorkingDirectory), false);
        cmd.setUsePreferenceTimeout("hg.timeout.clone");
        HgSvnClient.addRepoToHgCommand(repo, cmd);
        if (cloneName != null) {
            cmd.addOptions(cloneName);
        }
        if (timeout) {
            cmd.setUsePreferenceTimeout("hg.timeout.clone");
            cmd.executeToBytes();
        } else {
            cmd.executeToBytes(Integer.MAX_VALUE);
        }
    }
}

