/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class HgPushPullClient
extends AbstractClient {
    public static String push(IProject project, HgRepositoryLocation repo, boolean force, String revision, int timeout) throws HgException {
        HgCommand command = new HgCommand("push", (IContainer)project, true);
        command.setUsePreferenceTimeout("hg.timeout.push");
        if (force) {
            command.addOptions("-f");
        }
        if (revision != null && revision.length() > 0) {
            command.addOptions("-r", revision.trim());
        }
        HgPushPullClient.addRepoToHgCommand(repo, command);
        return new String(command.executeToBytes(timeout));
    }

    public static String pull(IResource resource, HgRepositoryLocation location, boolean update) throws HgException {
        return HgPushPullClient.pull(resource, location, update, false, false, null, false);
    }

    public static String pull(IResource resource, HgRepositoryLocation repo, boolean update, boolean force, boolean timeout, ChangeSet changeset, boolean rebase) throws HgException {
        URI uri = repo.getUri();
        String pullSource = uri != null ? uri.toASCIIString() : repo.getLocation();
        return HgPushPullClient.pull(resource, update, force, timeout, changeset, pullSource, rebase);
    }

    public static String pull(IResource resource, boolean update, boolean force, boolean timeout, ChangeSet changeset, String pullSource, boolean rebase) throws HgException {
        IResource workDir = resource;
        if (resource.getType() == 1) {
            workDir = resource.getParent();
        }
        HgCommand command = new HgCommand("pull", workDir.getLocation().toFile(), true);
        if (update) {
            command.addOptions("--update");
        } else if (rebase) {
            command.addOptions("--config", "extensions.hgext.rebase=");
            command.addOptions("--rebase");
        }
        if (force) {
            command.addOptions("--force");
        }
        if (changeset != null) {
            command.addOptions("--rev", changeset.getChangeset());
        }
        command.addOptions(pullSource);
        if (timeout) {
            command.setUsePreferenceTimeout("hg.timeout.pull");
            return new String(command.executeToBytes());
        }
        return new String(command.executeToBytes(Integer.MAX_VALUE));
    }
}

