/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class HgIgnoreClient {
    public static void addExtension(IFile file) throws HgException {
        HgIgnoreClient.addPattern(file.getProject(), "regexp", String.valueOf(HgIgnoreClient.escape("." + file.getFileExtension())) + "$");
    }

    public static void addFile(IFile file) throws HgException {
        String regexp = "^" + HgIgnoreClient.escape(file.getProjectRelativePath().toString()) + "$";
        HgIgnoreClient.addPattern(file.getProject(), "regexp", regexp);
    }

    public static void addFolder(IFolder folder) throws HgException {
        String regexp = "^" + HgIgnoreClient.escape(folder.getProjectRelativePath().toString()) + "$";
        HgIgnoreClient.addPattern(folder.getProject(), "regexp", regexp);
    }

    public static void addRegexp(IProject project, String regexp) throws HgException {
        HgIgnoreClient.addPattern(project, "regexp", regexp);
    }

    public static void addGlob(IProject project, String glob) throws HgException {
        HgIgnoreClient.addPattern(project, "glob", glob);
    }

    private static String escape(String string) {
        StringBuilder result = new StringBuilder();
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append('\\');
                }
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    private static void addPattern(IProject project, String syntax, String pattern) throws HgException {
        FilterOutputStream buffer = null;
        try {
            try {
                String path = HgRootClient.getHgRoot((IResource)project).concat(File.separator).concat(".hgignore");
                File hgignore = new File(path);
                buffer = new BufferedOutputStream(new FileOutputStream(hgignore, true));
                buffer.write(new byte[]{10, 115, 121, 110, 116, 97, 120, 58, 32});
                buffer.write(syntax.getBytes());
                ((BufferedOutputStream)buffer).write(10);
                buffer.write(pattern.getBytes());
                ((BufferedOutputStream)buffer).flush();
            }
            catch (CoreException e) {
                throw new HgException(Messages.getString("HgIgnoreClient.failedToAddHgIgnore"), e);
            }
            catch (IOException e) {
                throw new HgException(Messages.getString("HgIgnoreClient.failedToAddEntry"), e);
            }
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    throw new HgException(Messages.getString("HgIgnoreClient.failedToCloseHgIgnore"), e);
                }
            }
        }
    }
}

