/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;

public class HgIdentClient
extends AbstractClient {
    public static String getCurrentRevision(IContainer root) throws HgException {
        HgCommand command = new HgCommand("identify", root, true);
        command.addOptions("-n", "-i");
        command.setUsePreferenceTimeout("hg.timeout.status");
        return command.executeToString().trim();
    }

    public static String getCurrentRevision(IResource resource) throws HgException {
        HgCommand command = new HgCommand("identify", HgIdentClient.getWorkingDirectory(resource), true);
        command.setUsePreferenceTimeout("hg.timeout.status");
        command.addOptions("-nibt");
        return command.executeToString().trim();
    }

    static String getCurrentChangesetId(InputStream inputStream) throws IOException {
        StringBuilder id = new StringBuilder();
        int i = 0;
        int x = 0;
        while (i < 20 && (x = inputStream.read()) != -1) {
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                s = "0" + s;
            }
            id.append(s);
            ++i;
        }
        return id.toString();
    }

    public static String getCurrentChangesetId(File repository) throws HgException, IOException {
        FileInputStream reader;
        String dirstate = String.valueOf(repository.getCanonicalPath()) + File.separator + ".hg" + File.separator + "dirstate";
        try {
            reader = new FileInputStream(dirstate);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            String string = HgIdentClient.getCurrentChangesetId(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }
}

