/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;

public class HgCatClient {
    public static String getContent(IFile file, String revision) throws HgException {
        HgCommand command = new HgCommand("cat", file.getProject().getLocation().toFile(), true);
        if (revision != null && revision.length() != 0) {
            command.addOptions("--rev", revision);
        }
        command.addOptions("--decode");
        command.addOptions(file.getProjectRelativePath().toOSString());
        return command.executeToString();
    }

    public static String getContentFromBundle(IFile file, String revision, String overlayBundle) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(MercurialUtilities.getHGExecutable());
        command.add("-R");
        command.add(overlayBundle);
        command.add("cat");
        if (revision != null && revision.length() != 0) {
            command.add("-r");
            command.add("tip");
        }
        command.add("--decode");
        command.add(file.getProjectRelativePath().toOSString());
        HgCommand hgCommand = new HgCommand(command, file.getProject().getLocation().toFile(), true);
        return hgCommand.executeToString();
    }
}

