/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.ast;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExtensionStatement
extends Extension {
    protected final Identifier javaType;
    protected final Identifier javaMethod;
    protected final List<Identifier> javaParamTypes;
    protected final Identifier instanceSlot;

    public JavaExtensionStatement(int start, int end, int line, int startOffset, int endOffset, Identifier name, List<DeclaredParameter> formalParameters, Identifier returnType, Identifier defaultImplementation, Identifier javaMethod, List<Identifier> javaParamTypes, boolean cached, boolean isPrivate, Identifier instanceSlot) {
        super(start, end, line, startOffset, endOffset, name, returnType, formalParameters, cached, isPrivate);
        this.javaType = defaultImplementation;
        this.javaMethod = javaMethod;
        this.javaParamTypes = javaParamTypes;
        this.instanceSlot = instanceSlot;
    }

    public Identifier getJavaType() {
        return this.javaType;
    }

    public Identifier getJavaMethod() {
        return this.javaMethod;
    }

    public List<Identifier> getJavaParameterTypes() {
        return this.javaParamTypes;
    }

    @Override
    public Object evaluateInternal(Object[] parameters, ExecutionContext ctx) {
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        try {
            Method method = this.getJavaMethod(ctx, issues);
            if (method == null) {
                StringBuffer b = new StringBuffer();
                for (AnalysationIssue element : issues) {
                    b.append(element.toString()).append("\n");
                }
                throw new EvaluationException(String.valueOf(this.javaMethodToString()) + " not found, problems were: \n" + b, (SyntaxElement)this);
            }
            this.transformParameters(method.getParameterTypes(), parameters);
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, parameters);
            }
            if (this.instanceSlot == null) {
                throw new EvaluationException("Non-static method may be invoked only when slot with instance object is specified", (SyntaxElement)this);
            }
            Variable variable = ctx.getGlobalVariable(this.instanceSlot.getValue());
            if (variable == null || variable.getValue() == null) {
                throw new EvaluationException("The method '" + this.javaMethodToString() + "' is not static in " + this.javaType.getValue() + ", and there's no global variable '" + this.instanceSlot + "' to obtain instance from", (SyntaxElement)this);
            }
            if (!method.getDeclaringClass().isInstance(variable.getValue())) {
                throw new EvaluationException("Instance available in global vars as '" + this.instanceSlot + "' is not compatible with " + this.javaType.getValue(), (SyntaxElement)this);
            }
            return method.invoke(variable.getValue(), parameters);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getCause());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvaluationException(e, (SyntaxElement)this);
        }
    }

    private void transformParameters(Class[] paramTypes, Object[] parameters) {
        assert (paramTypes.length == parameters.length);
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] instanceof List && paramTypes[i].isArray()) {
                List list = (List)parameters[i];
                parameters[i] = list.toArray((Object[])Array.newInstance(paramTypes[i].getComponentType(), list.size()));
            }
            ++i;
        }
    }

    private String javaMethodToString() {
        StringBuffer buff = new StringBuffer();
        Iterator<Identifier> iter = this.javaParamTypes.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return this.javaType + "." + this.javaMethod + "(" + buff + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Method getJavaMethod(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            Class<?> clazz = null;
            clazz = ctx.loadClass(this.javaType.getValue());
            if (clazz == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.JAVA_TYPE_NOT_FOUND, this.javaType.getValue(), this.javaType, true));
                return null;
            }
            Class[] paramTypes = new Class[this.javaParamTypes.size()];
            int i = 0;
            int x = this.javaParamTypes.size();
            while (true) {
                if (i >= x) {
                    Method m = clazz.getMethod(this.javaMethod.getValue(), paramTypes);
                    if (this.instanceSlot == null && !Modifier.isStatic(m.getModifiers())) {
                        issues.add(new AnalysationIssue(AnalysationIssue.Type.FEATURE_NOT_FOUND, String.valueOf(this.javaMethod.getValue()) + " must be static (unless slot to get instance from is specified)!", this.javaMethod));
                    }
                    if (!Modifier.isPublic(m.getModifiers())) {
                        issues.add(new AnalysationIssue(AnalysationIssue.Type.FEATURE_NOT_FOUND, String.valueOf(this.javaMethod.getValue()) + " must be public!", this.javaMethod));
                    }
                    return m;
                }
                Identifier javaParamType = this.javaParamTypes.get(i);
                String value = javaParamType.getValue();
                boolean isList = value.endsWith(".List");
                if (isList) {
                    value = value.substring(0, value.length() - 5);
                }
                paramTypes[i] = ctx.loadClass(value);
                if (paramTypes[i] == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.Type.JAVA_TYPE_NOT_FOUND, value, javaParamType, true));
                    return null;
                }
                if (isList) {
                    paramTypes[i] = Array.newInstance(paramTypes[i], 0).getClass();
                }
                ++i;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.FEATURE_NOT_FOUND, this.javaMethod.getValue(), this.javaMethod));
            return null;
        }
    }

    @Override
    public void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.SYNTAX_ERROR, "A return type must be specified for java extensions!", this));
        }
        this.getJavaMethod(ctx, issues);
    }

    @Override
    protected EClassifier internalGetReturnType(EClassifier[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.SYNTAX_ERROR, "A return type must be specified for java extensions!", this));
            return null;
        }
        return ctx.getTypeForName(this.returnType.getValue());
    }
}

