/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyStore;
import org.eclipse.core.internal.properties.QueryResults;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.properties.StoredProperty;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.RootInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class PropertyManager
implements IManager,
ILifecycleListener,
IPropertyManager {
    protected Workspace workspace;

    public PropertyManager(Workspace workspace) {
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePropertyStore(IResource target) throws CoreException {
        PropertyStore store = this.getPropertyStoreOrNull(target);
        if (store == null) {
            return;
        }
        PropertyStore propertyStore = store;
        synchronized (propertyStore) {
            store.shutdown(null);
            this.setPropertyStore(target, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(IResource source, IResource destination, int depth) throws CoreException {
        PropertyStore sourceStore = this.getPropertyStore(source);
        PropertyStore destinationStore = this.getPropertyStore(destination);
        PropertyStore propertyStore = sourceStore;
        synchronized (propertyStore) {
            this.assertRunning(source, sourceStore);
            PropertyStore propertyStore2 = destinationStore;
            synchronized (propertyStore2) {
                this.assertRunning(destination, destinationStore);
                this.copyProperties(source, destination, depth);
                sourceStore.commit();
                destinationStore.commit();
            }
        }
    }

    private void assertRunning(IResource target, PropertyStore store) throws CoreException {
        if (!store.isRunning()) {
            String message = NLS.bind((String)CompatibilityMessages.resources_mustExist, (Object)target.getFullPath());
            throw new ResourceException(368, target.getFullPath(), message, null);
        }
    }

    private void copyProperties(IResource source, IResource destination, int depth) throws CoreException {
        PropertyStore sourceStore = this.getPropertyStore(source);
        PropertyStore destStore = this.getPropertyStore(destination);
        ResourceName sourceName = this.getPropertyKey(source);
        ResourceName destName = this.getPropertyKey(destination);
        QueryResults results = sourceStore.getAll(sourceName, depth);
        Enumeration resources = results.getResourceNames();
        while (resources.hasMoreElements()) {
            ResourceName resourceName = (ResourceName)resources.nextElement();
            List properties = results.getResults(resourceName);
            if (properties.isEmpty()) continue;
            StoredProperty[] propsArray = new StoredProperty[properties.size()];
            propsArray = properties.toArray(propsArray);
            int segmentsToDrop = source.getProjectRelativePath().matchingFirstSegments(resourceName.getPath());
            IPath path = destName.getPath().append(resourceName.getPath().removeFirstSegments(segmentsToDrop));
            resourceName = new ResourceName(resourceName.getQualifier(), path);
            destStore.set(resourceName, propsArray, 0, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperties(IResource target, int depth) throws CoreException {
        switch (target.getType()) {
            case 1: 
            case 2: {
                PropertyStore store;
                PropertyStore propertyStore = store = this.getPropertyStore(target);
                synchronized (propertyStore) {
                    this.assertRunning(target, store);
                    store.removeAll(this.getPropertyKey(target), depth);
                    store.commit();
                    break;
                }
            }
            case 4: 
            case 8: {
                this.deletePropertyStore(target, true);
            }
        }
    }

    public void deleteResource(IResource target) throws CoreException {
        switch (target.getType()) {
            case 1: 
            case 2: 
            case 8: {
                this.deleteProperties(target, 2);
                break;
            }
            case 4: {
                this.deletePropertyStore(target, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePropertyStore(IResource target, boolean restart) throws CoreException {
        PropertyStore store = this.getPropertyStoreOrNull(target);
        if (store == null) {
            return;
        }
        PropertyStore propertyStore = store;
        synchronized (propertyStore) {
            ResourceInfo info;
            store.shutdown(null);
            this.workspace.getMetaArea().getPropertyStoreLocation(target).toFile().delete();
            if (restart && (info = this.getPropertyHost(target).getResourceInfo(false, false)) != null) {
                info.setPropertyStore(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(IResource target, QualifiedName name) throws CoreException {
        PropertyStore store;
        PropertyStore propertyStore = store = this.getPropertyStore(target);
        synchronized (propertyStore) {
            this.assertRunning(target, store);
            StoredProperty result = store.get(this.getPropertyKey(target), name);
            return result == null ? null : result.getStringValue();
        }
    }

    private Resource getPropertyHost(IResource target) {
        return (Resource)(target.getType() == 8 ? target : target.getProject());
    }

    private ResourceName getPropertyKey(IResource target) {
        return new ResourceName("", target.getProjectRelativePath());
    }

    PropertyStore getPropertyStore(IResource target) throws CoreException {
        return this.getPropertyStore(target, true);
    }

    PropertyStore getPropertyStore(IResource target, boolean createIfNeeded) throws CoreException {
        try {
            Resource host = this.getPropertyHost(target);
            ResourceInfo info = host.getResourceInfo(false, false);
            if (info == null) {
                String message = NLS.bind((String)CompatibilityMessages.properties_storeNotAvailable, (Object)target.getFullPath());
                throw new ResourceException(271, target.getFullPath(), message, null);
            }
            PropertyStore store = (PropertyStore)info.getPropertyStore();
            if (store == null) {
                store = this.openPropertyStore((IResource)host, createIfNeeded);
            }
            return store;
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            String message = NLS.bind((String)CompatibilityMessages.properties_storeNotAvailable, (Object)target.getFullPath());
            throw new ResourceException(271, target.getFullPath(), message, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyStore getPropertyStoreOrNull(IResource target) {
        PropertyStore store;
        Resource host = this.getPropertyHost(target);
        ResourceInfo info = host.getResourceInfo(false, false);
        if (info != null && (store = (PropertyStore)info.getPropertyStore()) != null) {
            PropertyStore propertyStore = store;
            synchronized (propertyStore) {
                if (store.isRunning()) {
                    return store;
                }
            }
        }
        return null;
    }

    public void handleEvent(LifecycleEvent event) throws CoreException {
        if (event.kind == 1) {
            this.closePropertyStore(event.resource);
        }
    }

    private PropertyStore openPropertyStore(IResource target, boolean createIfNeeded) {
        int type = target.getType();
        Assert.isTrue((type != 1 && type != 2 ? 1 : 0) != 0);
        IPath location = this.workspace.getMetaArea().getPropertyStoreLocation(target);
        File storeFile = location.toFile();
        if (!createIfNeeded && !storeFile.isFile()) {
            return null;
        }
        storeFile.getParentFile().mkdirs();
        PropertyStore store = new PropertyStore(location);
        this.setPropertyStore(target, store);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(IResource target, QualifiedName key, String value) throws CoreException {
        PropertyStore store;
        PropertyStore propertyStore = store = this.getPropertyStore(target);
        synchronized (propertyStore) {
            this.assertRunning(target, store);
            if (value == null) {
                store.remove(this.getPropertyKey(target), key);
            } else {
                StoredProperty prop = new StoredProperty(key, value);
                store.set(this.getPropertyKey(target), prop);
            }
            store.commit();
        }
    }

    private void setPropertyStore(IResource target, PropertyStore value) {
        ResourceInfo info = this.getPropertyHost(target).getResourceInfo(false, false);
        if (info.getType() == 4) {
            ((ProjectInfo)info).setPropertyStore((Object)value);
        } else {
            ((RootInfo)info).setPropertyStore((Object)value);
        }
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
        this.closePropertyStore((IResource)this.workspace.getRoot());
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        this.workspace.addLifecycleListener((ILifecycleListener)this);
    }

    public Map getProperties(IResource resource) throws CoreException {
        PropertyStore store = this.getPropertyStore(resource);
        if (store == null) {
            return Collections.EMPTY_MAP;
        }
        IPath path = resource.getProjectRelativePath();
        ResourceName resourceName = new ResourceName("", path);
        QueryResults results = store.getAll(resourceName, 1);
        List projectProperties = results.getResults(resourceName);
        int listSize = projectProperties.size();
        if (listSize == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<QualifiedName, String> properties = new HashMap<QualifiedName, String>();
        int i = 0;
        while (i < listSize) {
            StoredProperty prop = (StoredProperty)projectProperties.get(i);
            properties.put(prop.getName(), prop.getStringValue());
            ++i;
        }
        return properties;
    }
}

