/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class ValuePropertyDetailSet
extends SetProperty {
    private IValueProperty masterProperty;
    private ISetProperty detailProperty;

    public ValuePropertyDetailSet(IValueProperty masterProperty, ISetProperty detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    public Object getElementType() {
        return this.detailProperty.getElementType();
    }

    public IObservableSet observe(Realm realm, Object source) {
        IObservableValue masterValue = this.masterProperty.observe(realm, source);
        IObservableSet detailSet = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose((IObservable)detailSet, (IObservable)masterValue);
        return detailSet;
    }

    public IObservableSet observeDetail(IObservableValue master) {
        IObservableValue masterValue = this.masterProperty.observeDetail(master);
        IObservableSet detailSet = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose((IObservable)detailSet, (IObservable)masterValue);
        return detailSet;
    }

    public String toString() {
        return this.masterProperty + " => " + this.detailProperty;
    }
}

