/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.equinox.http.servlet.HttpServiceServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class HttpServerManager
implements ManagedServiceFactory {
    private static final String CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private static final String DIR_PREFIX = "pid_";
    private static final String INTERNAL_CONTEXT_CLASSLOADER = "org.eclipse.equinox.http.jetty.internal.ContextClassLoader";
    private Map servers = new HashMap();
    private File workDir;

    public HttpServerManager(File workDir) {
        this.workDir = workDir;
    }

    public synchronized void deleted(String pid) {
        Server server = (Server)this.servers.remove(pid);
        if (server != null) {
            try {
                server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File contextWorkDir = new File(this.workDir, DIR_PREFIX + pid.hashCode());
            HttpServerManager.deleteDirectory(contextWorkDir);
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    public synchronized void updated(String pid, Dictionary dictionary) throws ConfigurationException {
        String otherInfo;
        int port;
        this.deleted(pid);
        Server server = new Server();
        JettyCustomizer customizer = this.createJettyCustomizer(dictionary);
        Connector httpConnector = this.createHttpConnector(dictionary);
        if (customizer != null) {
            httpConnector = (Connector)customizer.customizeHttpConnector(httpConnector, dictionary);
        }
        if (httpConnector != null) {
            server.addConnector(httpConnector);
        }
        Connector httpsConnector = this.createHttpsConnector(dictionary);
        if (customizer != null) {
            httpsConnector = (Connector)customizer.customizeHttpsConnector(httpsConnector, dictionary);
        }
        if (httpsConnector != null) {
            server.addConnector(httpsConnector);
        }
        ServletHolder holder = new ServletHolder((Servlet)new InternalHttpServiceServlet());
        holder.setInitOrder(0);
        holder.setInitParameter("service.vendor", "Eclipse.org");
        holder.setInitParameter("service.description", "Equinox Jetty-based Http Service");
        if (httpConnector != null) {
            port = httpConnector.getLocalPort();
            if (port == -1) {
                port = httpConnector.getPort();
            }
            holder.setInitParameter("http.port", Integer.toString(port));
        }
        if (httpsConnector != null) {
            port = httpsConnector.getLocalPort();
            if (port == -1) {
                port = httpsConnector.getPort();
            }
            holder.setInitParameter("https.port", Integer.toString(port));
        }
        if ((otherInfo = (String)dictionary.get("other.info")) != null) {
            holder.setInitParameter("other.info", otherInfo);
        }
        Context httpContext = this.createHttpContext(dictionary);
        if (customizer != null) {
            httpContext = (Context)customizer.customizeContext(httpContext, dictionary);
        }
        httpContext.addServlet(holder, "/*");
        server.addHandler((Handler)httpContext);
        try {
            server.start();
        }
        catch (Exception e) {
            throw new ConfigurationException(pid, e.getMessage(), (Throwable)e);
        }
        this.servers.put(pid, server);
    }

    public synchronized void shutdown() throws Exception {
        Iterator it = this.servers.values().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            server.stop();
        }
        this.servers.clear();
    }

    private Connector createHttpConnector(Dictionary dictionary) {
        Boolean httpEnabled = (Boolean)dictionary.get("http.enabled");
        if (httpEnabled != null && !httpEnabled.booleanValue()) {
            return null;
        }
        Integer httpPort = (Integer)dictionary.get("http.port");
        if (httpPort == null) {
            return null;
        }
        Boolean nioEnabled = (Boolean)dictionary.get("http.nio");
        if (nioEnabled == null) {
            nioEnabled = this.getDefaultNIOEnablement();
        }
        Object connector = nioEnabled != false ? new SelectChannelConnector() : new SocketConnector();
        connector.setPort(httpPort.intValue());
        String httpHost = (String)dictionary.get("http.host");
        if (httpHost != null) {
            connector.setHost(httpHost);
        }
        if (connector.getPort() == 0) {
            try {
                connector.open();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return connector;
    }

    private Boolean getDefaultNIOEnablement() {
        Properties systemProperties = System.getProperties();
        String javaVendor = systemProperties.getProperty("java.vendor", "");
        if (javaVendor.equals("IBM Corporation")) {
            String javaVersion = systemProperties.getProperty("java.version", "");
            if (javaVersion.startsWith("1.4")) {
                return Boolean.FALSE;
            }
            if (javaVersion.equals("1.6.0")) {
                String jclVersion = systemProperties.getProperty("java.jcl.version", "");
                if (jclVersion.startsWith("2007")) {
                    return Boolean.FALSE;
                }
                if (jclVersion.startsWith("2008") && !jclVersion.startsWith("200811") && !jclVersion.startsWith("200812")) {
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }

    private Connector createHttpsConnector(Dictionary dictionary) {
        String keystoreType;
        String protocol;
        Object wantClientAuth;
        Object needClientAuth;
        String keyPassword;
        String password;
        String keyStore;
        Boolean httpsEnabled = (Boolean)dictionary.get("https.enabled");
        if (httpsEnabled == null || !httpsEnabled.booleanValue()) {
            return null;
        }
        Integer httpsPort = (Integer)dictionary.get("https.port");
        if (httpsPort == null) {
            return null;
        }
        SslSocketConnector sslConnector = new SslSocketConnector();
        sslConnector.setPort(httpsPort.intValue());
        String httpsHost = (String)dictionary.get("https.host");
        if (httpsHost != null) {
            sslConnector.setHost(httpsHost);
        }
        if ((keyStore = (String)dictionary.get("ssl.keystore")) != null) {
            sslConnector.setKeystore(keyStore);
        }
        if ((password = (String)dictionary.get("ssl.password")) != null) {
            sslConnector.setPassword(password);
        }
        if ((keyPassword = (String)dictionary.get("ssl.keypassword")) != null) {
            sslConnector.setKeyPassword(keyPassword);
        }
        if ((needClientAuth = dictionary.get("ssl.needclientauth")) != null) {
            if (needClientAuth instanceof String) {
                needClientAuth = Boolean.valueOf((String)needClientAuth);
            }
            sslConnector.setNeedClientAuth(((Boolean)needClientAuth).booleanValue());
        }
        if ((wantClientAuth = dictionary.get("ssl.wantclientauth")) != null) {
            if (wantClientAuth instanceof String) {
                wantClientAuth = Boolean.valueOf((String)wantClientAuth);
            }
            sslConnector.setWantClientAuth(((Boolean)wantClientAuth).booleanValue());
        }
        if ((protocol = (String)dictionary.get("ssl.protocol")) != null) {
            sslConnector.setProtocol(protocol);
        }
        if ((keystoreType = (String)dictionary.get("ssl.keystoretype")) != null) {
            sslConnector.setKeystoreType(keystoreType);
        }
        if (sslConnector.getPort() == 0) {
            try {
                sslConnector.open();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sslConnector;
    }

    private Context createHttpContext(Dictionary dictionary) {
        Context httpContext = new Context();
        httpContext.setAttribute(INTERNAL_CONTEXT_CLASSLOADER, (Object)Thread.currentThread().getContextClassLoader());
        httpContext.setClassLoader(this.getClass().getClassLoader());
        String contextPathProperty = (String)dictionary.get("context.path");
        if (contextPathProperty == null) {
            contextPathProperty = "/";
        }
        httpContext.setContextPath(contextPathProperty);
        File contextWorkDir = new File(this.workDir, DIR_PREFIX + dictionary.get("service.pid").hashCode());
        contextWorkDir.mkdir();
        httpContext.setAttribute(CONTEXT_TEMPDIR, (Object)contextWorkDir);
        HashSessionManager sessionManager = new HashSessionManager();
        Integer sessionInactiveInterval = (Integer)dictionary.get("context.sessioninactiveinterval");
        if (sessionInactiveInterval != null) {
            sessionManager.setMaxInactiveInterval(sessionInactiveInterval.intValue());
        }
        httpContext.setSessionHandler(new SessionHandler((SessionManager)sessionManager));
        return httpContext;
    }

    private JettyCustomizer createJettyCustomizer(Dictionary dictionary) {
        String customizerClass = (String)dictionary.get("customizer.class");
        if (customizerClass == null) {
            return null;
        }
        try {
            return (JettyCustomizer)Class.forName(customizerClass).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    HttpServerManager.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return directory.delete();
    }

    public static class InternalHttpServiceServlet
    implements Servlet {
        private static final long serialVersionUID = 7477982882399972088L;
        private Servlet httpServiceServlet = new HttpServiceServlet();
        private ClassLoader contextLoader;

        public void init(ServletConfig config) throws ServletException {
            ServletContext context = config.getServletContext();
            this.contextLoader = (ClassLoader)context.getAttribute(HttpServerManager.INTERNAL_CONTEXT_CLASSLOADER);
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.init(config);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        public void destroy() {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.destroy();
            }
            finally {
                thread.setContextClassLoader(current);
            }
            this.contextLoader = null;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.service(req, res);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        public ServletConfig getServletConfig() {
            return this.httpServiceServlet.getServletConfig();
        }

        public String getServletInfo() {
            return this.httpServiceServlet.getServletInfo();
        }
    }
}

