/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.DesktopDownloadMergeInputProvider;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.MergeOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.collabnet.subversion.merge";
    public static final String MERGE_INPUT_PROVIDERS = "com.collabnet.subversion.merge.mergeInputProviders";
    public static final String MERGE_PROVIDER = "CollabNet Desktop";
    public static final String MERGE_PROVIDER_SET = "merge_provider_set";
    private static Activator plugin;
    private static IMergeInputProvider[] mergeInputProviders;
    private static List mergeInputImages;
    private Hashtable imageDescriptors;
    public static final String IMAGE_COLLABNET = "collabnet.gif";
    public static final String IMAGE_COLLABNET_WIZBAN = "collabnet_wizban.gif";
    public static final String IMAGE_TEAMFORGE_LOGO = "teamForge_logo.gif";
    public static final String IMAGE_MERGE_OUTPUT = "merge_output.gif";
    public static final String IMAGE_MERGE_OUTPUT_IN_PROGRESS = "merge_output_in_progress.gif";
    public static final String IMAGE_MERGE_OUTPUT_ABNORMAL = "merge_output_abnormal.gif";
    public static final String IMAGE_MERGE_OUTPUT_ABORTED = "merge_aborted.gif";
    public static final String IMAGE_REFRESH = "refresh.gif";
    public static final String IMAGE_EXPAND_ALL = "expandall.gif";
    public static final String IMAGE_COLLAPSE_ALL = "collapseall.gif";
    public static final String IMAGE_LAYOUT_FLAT = "flatLayout.gif";
    public static final String IMAGE_LAYOUT_COMPRESSED = "compressedLayout.gif";
    public static final String IMAGE_CONFLICT = "conflict.gif";
    public static final String IMAGE_PRESENTATION = "presentation.gif";
    public static final String IMAGE_REMOVE = "remove.gif";
    public static final String IMAGE_REMOVE_ALL = "remove_all.gif";
    public static final String IMAGE_TASK_REPOSITORY = "repository.gif";
    public static final String IMAGE_MERGE_WIZARD = "mergestream_wizban.png";
    public static final String IMAGE_EXPORT_MERGE_OUTPUT_WIZARD = "export_merge.png";
    public static final String IMAGE_SVN = "svn_wizban.png";
    public static final String IMAGE_CHANGE_SETS = "changesets.png";
    public static final String IMAGE_CHECK = "checkmark.png";
    public static final String IMAGE_PROBLEM = "icon-error.png";
    public static final String IMAGE_OVERLAY_ADD = "ovr/r_inadd_ov.gif";
    public static final String IMAGE_OVERLAY_CHANGE = "ovr/r_inchg_ov.gif";
    public static final String IMAGE_OVERLAY_DELETE = "ovr/r_indel_ov.gif";
    public static final String IMAGE_OVERLAY_RESOLVED = "ovr/resolved_ov.gif";
    public static final String IMAGE_OVERLAY_CONFLICTED_CHANGE = "ovr/confchg_ov.gif";
    public static final String IMAGE_OVERLAY_CONFLICTED_DELETE = "ovr/confdel_ov.gif";
    public static final String IMAGE_OVERLAY_CONFLICTED_ADD = "ovr/confadd_ov.gif";
    public static final String IMAGE_OVERLAY_ERROR = "ovr/error_ov.gif";
    public static final String IMAGE_OVERLAY_TREE_CONFLICT = "ovr/tree_conflict_ov.gif";
    public static final String IMAGE_OVERLAY_PROPERTY_ADD = "ovr/props/add_ov.gif";
    public static final String IMAGE_OVERLAY_PROPERTY_CHANGE = "ovr/props/chg_ov.gif";
    public static final String IMAGE_OVERLAY_PROPERTY_DELETE = "ovr/props/del_ov.gif";
    public static final String IMAGE_OVERLAY_PROPERTY_CONFLICTED_ADD = "ovr/props/confadd_ov.gif";
    public static final String IMAGE_OVERLAY_PROPERTY_CONFLICTED_CHANGE = "ovr/props/confchg_ov.gif";
    public static final String IMAGE_OVERLAY_PROPERTY_CONFLICTED_DELETE = "ovr/props/confdel_ov.gif";

    static {
        mergeInputImages = new ArrayList();
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        mergeInputProviders = Activator.getMergeInputProviders();
        boolean mergeProviderSet = this.getPreferenceStore().getBoolean(MERGE_PROVIDER_SET);
        if (!mergeProviderSet) {
            this.getPreferenceStore().setValue(MERGE_PROVIDER_SET, true);
            SVNUIPlugin.getPlugin().getPreferenceStore().setValue("pref_merge_provider", MERGE_PROVIDER);
        }
        MergeOutput[] mergeOutputs = MergeOutput.getMergeOutputs();
        int i = 0;
        while (i < mergeOutputs.length) {
            if (!mergeOutputs[i].isNormalEnd()) {
                mergeOutputs[i].setAbnormalEnd(true);
                mergeOutputs[i].getMergeResults();
                mergeOutputs[i].store();
            }
            ++i;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        for (Image image : mergeInputImages) {
            image.dispose();
        }
        super.stop(context);
    }

    public boolean isDesktopInstalled() {
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)"com.collabnet.desktop");
        }
        catch (Exception exception) {}
        return bundle != null;
    }

    public static IMergeInputProvider[] getMergeInputProviders() throws Exception {
        if (mergeInputProviders == null) {
            ArrayList<IMergeInputProvider> inputProviderList = new ArrayList<IMergeInputProvider>();
            if (!Activator.getDefault().isDesktopInstalled()) {
                DesktopDownloadMergeInputProvider desktopDownloadMergeInputProvider = new DesktopDownloadMergeInputProvider();
                inputProviderList.add(desktopDownloadMergeInputProvider);
            }
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor(MERGE_INPUT_PROVIDERS);
            int i = 0;
            while (i < configurationElements.length) {
                String seq;
                IConfigurationElement configurationElement = configurationElements[i];
                IMergeInputProvider inputProvider = (IMergeInputProvider)configurationElement.createExecutableExtension("class");
                inputProvider.setText(configurationElement.getAttribute("name"));
                inputProvider.setDescription(configurationElement.getAttribute("description").replaceAll("%NL%", System.getProperty("line.separator")));
                String imageKey = configurationElement.getAttribute("image");
                if (imageKey != null) {
                    ImageDescriptor imageDescriptor = Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + imageKey));
                    Image image = imageDescriptor.createImage();
                    mergeInputImages.add(image);
                    inputProvider.setImage(image);
                }
                if ((seq = configurationElement.getAttribute("sequence")) != null) {
                    inputProvider.setSequence(Integer.parseInt(seq));
                }
                inputProviderList.add(inputProvider);
                ++i;
            }
            mergeInputProviders = new IMergeInputProvider[inputProviderList.size()];
            inputProviderList.toArray(mergeInputProviders);
            Arrays.sort(mergeInputProviders);
        }
        return mergeInputProviders;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getMergeResultsLocation() {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + File.separator + ".metadata" + File.separator + ".plugins" + File.separator + PLUGIN_ID + File.separator + "MergeResults";
    }

    public static void handleError(Exception exception) {
        Activator.handleError(null, exception);
    }

    public static void handleError(String message, Exception exception) {
        if (message == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, (Throwable)exception));
        }
    }

    public void saveMergeSource(String mergeFrom, String commonRoot) {
        ArrayList<String> fromUrls = new ArrayList<String>();
        fromUrls.add(mergeFrom);
        String previousFromUrls = null;
        try {
            previousFromUrls = Activator.getDefault().getDialogSettings().get("mergeFromUrls_" + commonRoot);
        }
        catch (Exception exception) {}
        if (previousFromUrls != null) {
            String[] urls;
            String[] stringArray = urls = previousFromUrls.split("\\,");
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                if (!fromUrls.contains(url)) {
                    fromUrls.add(url);
                }
                ++n2;
            }
        }
        StringBuffer mergeFromBuffer = new StringBuffer(mergeFrom);
        for (String url : fromUrls) {
            mergeFromBuffer.append("," + url);
        }
        Activator.getDefault().getDialogSettings().put("mergeFromUrls_" + commonRoot, mergeFromBuffer.toString());
    }

    public ImageDescriptor getImageDescriptor(String id) {
        if (this.imageDescriptors == null) {
            // empty if block
        }
        this.initializeImages();
        return (ImageDescriptor)this.imageDescriptors.get(id);
    }

    private void createImageDescriptor(String id) {
        this.imageDescriptors.put(id, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + id)));
    }

    public static Image getImage(String key) {
        return Activator.getDefault().getImageRegistry().get(key);
    }

    private void initializeImages() {
        this.imageDescriptors = new Hashtable(40);
        this.createImageDescriptor(IMAGE_MERGE_OUTPUT);
        this.createImageDescriptor(IMAGE_MERGE_OUTPUT_IN_PROGRESS);
        this.createImageDescriptor(IMAGE_MERGE_OUTPUT_ABNORMAL);
        this.createImageDescriptor(IMAGE_MERGE_OUTPUT_ABORTED);
        this.createImageDescriptor(IMAGE_REFRESH);
        this.createImageDescriptor(IMAGE_EXPAND_ALL);
        this.createImageDescriptor(IMAGE_COLLAPSE_ALL);
        this.createImageDescriptor(IMAGE_LAYOUT_COMPRESSED);
        this.createImageDescriptor(IMAGE_LAYOUT_FLAT);
        this.createImageDescriptor(IMAGE_CONFLICT);
        this.createImageDescriptor(IMAGE_REMOVE);
        this.createImageDescriptor(IMAGE_REMOVE_ALL);
        this.createImageDescriptor(IMAGE_PRESENTATION);
        this.createImageDescriptor(IMAGE_OVERLAY_ADD);
        this.createImageDescriptor(IMAGE_OVERLAY_CHANGE);
        this.createImageDescriptor(IMAGE_OVERLAY_TREE_CONFLICT);
        this.createImageDescriptor(IMAGE_OVERLAY_DELETE);
        this.createImageDescriptor(IMAGE_OVERLAY_RESOLVED);
        this.createImageDescriptor(IMAGE_OVERLAY_CONFLICTED_ADD);
        this.createImageDescriptor(IMAGE_OVERLAY_CONFLICTED_CHANGE);
        this.createImageDescriptor(IMAGE_OVERLAY_CONFLICTED_DELETE);
        this.createImageDescriptor(IMAGE_OVERLAY_ERROR);
        this.createImageDescriptor(IMAGE_OVERLAY_PROPERTY_ADD);
        this.createImageDescriptor(IMAGE_OVERLAY_PROPERTY_CHANGE);
        this.createImageDescriptor(IMAGE_OVERLAY_PROPERTY_DELETE);
        this.createImageDescriptor(IMAGE_OVERLAY_PROPERTY_CONFLICTED_ADD);
        this.createImageDescriptor(IMAGE_OVERLAY_PROPERTY_CONFLICTED_CHANGE);
        this.createImageDescriptor(IMAGE_OVERLAY_PROPERTY_CONFLICTED_DELETE);
        this.createImageDescriptor(IMAGE_MERGE_WIZARD);
        this.createImageDescriptor(IMAGE_EXPORT_MERGE_OUTPUT_WIZARD);
        this.createImageDescriptor(IMAGE_CHECK);
        this.createImageDescriptor(IMAGE_PROBLEM);
        this.createImageDescriptor(IMAGE_SVN);
        this.createImageDescriptor(IMAGE_TASK_REPOSITORY);
        this.createImageDescriptor(IMAGE_COLLABNET);
        this.createImageDescriptor(IMAGE_COLLABNET_WIZBAN);
        this.createImageDescriptor(IMAGE_TEAMFORGE_LOGO);
        this.createImageDescriptor(IMAGE_CHANGE_SETS);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMAGE_MERGE_OUTPUT, this.getImageDescriptor(IMAGE_MERGE_OUTPUT));
        reg.put(IMAGE_MERGE_OUTPUT_IN_PROGRESS, this.getImageDescriptor(IMAGE_MERGE_OUTPUT_IN_PROGRESS));
        reg.put(IMAGE_MERGE_OUTPUT_ABNORMAL, this.getImageDescriptor(IMAGE_MERGE_OUTPUT_ABNORMAL));
        reg.put(IMAGE_MERGE_OUTPUT_ABORTED, this.getImageDescriptor(IMAGE_MERGE_OUTPUT_ABORTED));
        reg.put(IMAGE_REFRESH, this.getImageDescriptor(IMAGE_REFRESH));
        reg.put(IMAGE_EXPAND_ALL, this.getImageDescriptor(IMAGE_EXPAND_ALL));
        reg.put(IMAGE_COLLAPSE_ALL, this.getImageDescriptor(IMAGE_COLLAPSE_ALL));
        reg.put(IMAGE_LAYOUT_COMPRESSED, this.getImageDescriptor(IMAGE_LAYOUT_COMPRESSED));
        reg.put(IMAGE_LAYOUT_FLAT, this.getImageDescriptor(IMAGE_LAYOUT_FLAT));
        reg.put(IMAGE_CONFLICT, this.getImageDescriptor(IMAGE_CONFLICT));
        reg.put(IMAGE_REMOVE, this.getImageDescriptor(IMAGE_REMOVE));
        reg.put(IMAGE_REMOVE_ALL, this.getImageDescriptor(IMAGE_REMOVE_ALL));
        reg.put(IMAGE_PRESENTATION, this.getImageDescriptor(IMAGE_PRESENTATION));
        reg.put(IMAGE_OVERLAY_ADD, this.getImageDescriptor(IMAGE_OVERLAY_ADD));
        reg.put(IMAGE_OVERLAY_CHANGE, this.getImageDescriptor(IMAGE_OVERLAY_CHANGE));
        reg.put(IMAGE_OVERLAY_TREE_CONFLICT, this.getImageDescriptor(IMAGE_OVERLAY_TREE_CONFLICT));
        reg.put(IMAGE_OVERLAY_DELETE, this.getImageDescriptor(IMAGE_OVERLAY_DELETE));
        reg.put(IMAGE_OVERLAY_RESOLVED, this.getImageDescriptor(IMAGE_OVERLAY_RESOLVED));
        reg.put(IMAGE_OVERLAY_CONFLICTED_ADD, this.getImageDescriptor(IMAGE_OVERLAY_CONFLICTED_ADD));
        reg.put(IMAGE_OVERLAY_CONFLICTED_CHANGE, this.getImageDescriptor(IMAGE_OVERLAY_CONFLICTED_CHANGE));
        reg.put(IMAGE_OVERLAY_CONFLICTED_DELETE, this.getImageDescriptor(IMAGE_OVERLAY_CONFLICTED_DELETE));
        reg.put(IMAGE_OVERLAY_ERROR, this.getImageDescriptor(IMAGE_OVERLAY_ERROR));
        reg.put(IMAGE_OVERLAY_PROPERTY_ADD, this.getImageDescriptor(IMAGE_OVERLAY_PROPERTY_ADD));
        reg.put(IMAGE_OVERLAY_PROPERTY_CHANGE, this.getImageDescriptor(IMAGE_OVERLAY_PROPERTY_CHANGE));
        reg.put(IMAGE_OVERLAY_PROPERTY_DELETE, this.getImageDescriptor(IMAGE_OVERLAY_PROPERTY_DELETE));
        reg.put(IMAGE_OVERLAY_PROPERTY_CONFLICTED_ADD, this.getImageDescriptor(IMAGE_OVERLAY_PROPERTY_CONFLICTED_ADD));
        reg.put(IMAGE_OVERLAY_PROPERTY_CONFLICTED_CHANGE, this.getImageDescriptor(IMAGE_OVERLAY_PROPERTY_CONFLICTED_CHANGE));
        reg.put(IMAGE_OVERLAY_PROPERTY_CONFLICTED_DELETE, this.getImageDescriptor(IMAGE_OVERLAY_PROPERTY_CONFLICTED_DELETE));
        reg.put(IMAGE_MERGE_WIZARD, this.getImageDescriptor(IMAGE_MERGE_WIZARD));
        reg.put(IMAGE_EXPORT_MERGE_OUTPUT_WIZARD, this.getImageDescriptor(IMAGE_EXPORT_MERGE_OUTPUT_WIZARD));
        reg.put(IMAGE_SVN, this.getImageDescriptor(IMAGE_SVN));
        reg.put(IMAGE_CHECK, this.getImageDescriptor(IMAGE_CHECK));
        reg.put(IMAGE_PROBLEM, this.getImageDescriptor(IMAGE_PROBLEM));
        reg.put(IMAGE_TASK_REPOSITORY, this.getImageDescriptor(IMAGE_TASK_REPOSITORY));
        reg.put(IMAGE_COLLABNET, this.getImageDescriptor(IMAGE_COLLABNET));
        reg.put(IMAGE_COLLABNET_WIZBAN, this.getImageDescriptor(IMAGE_COLLABNET_WIZBAN));
        reg.put(IMAGE_TEAMFORGE_LOGO, this.getImageDescriptor(IMAGE_TEAMFORGE_LOGO));
        reg.put(IMAGE_CHANGE_SETS, this.getImageDescriptor(IMAGE_CHANGE_SETS));
    }
}

