/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.mirror;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.mirror.IArtifactMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactComparatorFactory;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactComparator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.osgi.util.NLS;

public class Mirroring {
    private IArtifactRepository source;
    private IArtifactRepository destination;
    private IArtifactRepository baseline;
    private boolean raw;
    private boolean compare = false;
    private boolean validate = false;
    private IArtifactComparator comparator;
    private String comparatorID;
    private IArtifactKey[] keysToMirror;
    private IArtifactMirrorLog comparatorLog;

    private IArtifactComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = ArtifactComparatorFactory.getArtifactComparator(this.comparatorID);
        }
        return this.comparator;
    }

    public Mirroring(IArtifactRepository source, IArtifactRepository destination, boolean raw) {
        this.source = source;
        this.destination = destination;
        this.raw = raw;
    }

    public void setCompare(boolean compare) {
        this.compare = compare;
    }

    public void setComparatorId(String id) {
        this.comparatorID = id;
    }

    public void setComparatorLog(IArtifactMirrorLog comparatorLog) {
        this.comparatorLog = comparatorLog;
    }

    public void setBaseline(IArtifactRepository baseline) {
        this.baseline = baseline;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public MultiStatus run(boolean failOnError, boolean verbose) {
        IStatus validation;
        if (!this.destination.isModifiable()) {
            throw new IllegalStateException(NLS.bind((String)Messages.exception_destinationNotModifiable, (Object)this.destination.getLocation()));
        }
        if (this.compare) {
            this.getComparator();
        }
        IArtifactKey[] keys = this.keysToMirror == null ? this.source.getArtifactKeys() : this.keysToMirror;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 0, Messages.message_mirroringStatus, null);
        int i = 0;
        while (i < keys.length) {
            IArtifactKey key = keys[i];
            IArtifactDescriptor[] descriptors = this.source.getArtifactDescriptors(key);
            int j = 0;
            while (j < descriptors.length) {
                IStatus result = this.mirror(descriptors[j], verbose);
                if (!result.isOK() && (verbose || result.getSeverity() == 4)) {
                    multiStatus.add(result);
                }
                if (failOnError && multiStatus.getSeverity() == 4) {
                    return multiStatus;
                }
                ++j;
            }
            ++i;
        }
        if (this.validate && !(validation = this.validateMirror(verbose)).isOK() && (verbose || validation.getSeverity() == 4)) {
            multiStatus.add(validation);
        }
        return multiStatus;
    }

    private IStatus mirror(IArtifactDescriptor descriptor, boolean verbose) {
        IArtifactDescriptor baselineDescriptor;
        IArtifactDescriptor newDescriptor;
        IArtifactDescriptor iArtifactDescriptor = newDescriptor = this.raw ? descriptor : new ArtifactDescriptor(descriptor);
        if (verbose) {
            System.out.println("Mirroring: " + descriptor.getArtifactKey() + " (Descriptor: " + descriptor + ")");
        }
        if (this.compare && this.baseline != null && this.baseline.contains(descriptor) && (baselineDescriptor = this.getBaselineDescriptor(descriptor)) != null) {
            MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 0, NLS.bind((String)Messages.Mirroring_compareAndDownload, (Object)descriptor), null);
            IStatus comparison = this.getComparator().compare(this.baseline, baselineDescriptor, this.source, descriptor);
            if (this.comparatorLog != null) {
                this.comparatorLog.log(baselineDescriptor, comparison);
            }
            status.add(comparison);
            if (this.destination.contains(baselineDescriptor)) {
                return this.compareToDestination(baselineDescriptor);
            }
            status.add(this.downloadArtifact(this.baseline, baselineDescriptor, baselineDescriptor));
            return status;
        }
        if (this.destination.contains(newDescriptor)) {
            if (this.compare) {
                return this.compareToDestination(descriptor);
            }
            String message = NLS.bind((String)Messages.mirror_alreadyExists, (Object)descriptor, (Object)this.destination);
            return new Status(1, "org.eclipse.equinox.p2.artifact.repository", 1201, message, null);
        }
        return this.downloadArtifact(this.source, newDescriptor, descriptor);
    }

    private IStatus compareToDestination(IArtifactDescriptor descriptor) {
        IArtifactDescriptor[] destDescriptors = this.destination.getArtifactDescriptors(descriptor.getArtifactKey());
        IArtifactDescriptor destDescriptor = null;
        int i = 0;
        while (destDescriptor == null && i < destDescriptors.length) {
            if (destDescriptors[i].equals(descriptor)) {
                destDescriptor = destDescriptors[i];
            }
            ++i;
        }
        if (destDescriptor == null) {
            return new Status(1, "org.eclipse.equinox.p2.artifact.repository", 1201, Messages.Mirroring_NO_MATCHING_DESCRIPTOR, null);
        }
        return this.compare(this.source, descriptor, this.destination, destDescriptor);
    }

    private IStatus compare(IArtifactRepository sourceRepository, IArtifactDescriptor sourceDescriptor, IArtifactRepository destRepository, IArtifactDescriptor destDescriptor) {
        IStatus comparison = this.getComparator().compare(sourceRepository, sourceDescriptor, destRepository, destDescriptor);
        if (this.comparatorLog != null) {
            this.comparatorLog.log(sourceDescriptor, comparison);
        }
        return comparison;
    }

    private IStatus downloadArtifact(IArtifactRepository sourceRepo, IArtifactDescriptor destDescriptor, IArtifactDescriptor srcDescriptor) {
        RawMirrorRequest request = new RawMirrorRequest(srcDescriptor, destDescriptor, this.destination);
        request.setSourceRepository(sourceRepo);
        request.perform((IProgressMonitor)new NullProgressMonitor());
        return request.getResult();
    }

    public void setArtifactKeys(IArtifactKey[] keys) {
        this.keysToMirror = keys;
    }

    private IArtifactDescriptor getBaselineDescriptor(IArtifactDescriptor descriptor) {
        IArtifactDescriptor[] baselineDescriptors = this.baseline.getArtifactDescriptors(descriptor.getArtifactKey());
        int i = 0;
        while (i < baselineDescriptors.length) {
            if (baselineDescriptors[i].equals(descriptor)) {
                return baselineDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    private IStatus validateMirror(boolean verbose) {
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 0, Messages.Mirroring_ValidationError, null);
        IArtifactKey[] keys = this.keysToMirror == null ? this.source.getArtifactKeys() : this.keysToMirror;
        int i = 0;
        while (i < keys.length) {
            IArtifactDescriptor[] srcDescriptors = this.source.getArtifactDescriptors(keys[i]);
            IArtifactDescriptor[] destDescriptors = this.destination.getArtifactDescriptors(keys[i]);
            Arrays.sort(srcDescriptors, new ArtifactDescriptorComparator());
            Arrays.sort(destDescriptors, new ArtifactDescriptorComparator());
            int src = 0;
            int dest = 0;
            while (src < srcDescriptors.length && dest < destDescriptors.length) {
                IArtifactDescriptor baselineDescriptor;
                if (!destDescriptors[dest].equals(srcDescriptors[src])) {
                    if (destDescriptors[dest].toString().compareTo(srcDescriptors[src].toString()) > 0) {
                        if (verbose) {
                            System.out.println(NLS.bind((String)Messages.Mirroring_MISSING_DESCRIPTOR, (Object)srcDescriptors[src]));
                        }
                        status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Mirroring_MISSING_DESCRIPTOR, (Object)srcDescriptors[src++])));
                        continue;
                    }
                    ++dest;
                    continue;
                }
                Map destMap = destDescriptors[dest].getProperties();
                Map srcProperties = null;
                if (this.baseline != null && (baselineDescriptor = this.getBaselineDescriptor(destDescriptors[dest])) != null) {
                    srcProperties = baselineDescriptor.getProperties();
                }
                if (srcProperties == null) {
                    srcProperties = srcDescriptors[src].getProperties();
                }
                Iterator iter = srcProperties.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    if (srcProperties.get(key).equals(destMap.get(key))) continue;
                    if (verbose) {
                        System.out.println(NLS.bind((String)Messages.Mirroring_DIFFERENT_DESCRIPTOR_PROPERTY, (Object[])new Object[]{destDescriptors[dest], key, srcProperties.get(key), destMap.get(key)}));
                    }
                    status.add((IStatus)new Status(2, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Mirroring_DIFFERENT_DESCRIPTOR_PROPERTY, (Object[])new Object[]{destDescriptors[dest], key, srcProperties.get(key), destMap.get(key)})));
                }
                ++src;
                ++dest;
            }
            while (src < srcDescriptors.length) {
                if (verbose) {
                    System.out.println(NLS.bind((String)Messages.Mirroring_MISSING_DESCRIPTOR, (Object)srcDescriptors[src]));
                }
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Mirroring_MISSING_DESCRIPTOR, (Object)srcDescriptors[src++])));
            }
            ++i;
        }
        return status;
    }

    protected class ArtifactDescriptorComparator
    implements Comparator {
        protected ArtifactDescriptorComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 != null && arg1 != null) {
                return arg0.toString().compareTo(arg1.toString());
            }
            if (arg1 == null && arg0 == null) {
                return 0;
            }
            if (arg1 == null) {
                return 1;
            }
            return -1;
        }
    }
}

