/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgPatchClient;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.ui.LocationChooser;
import com.vectrace.MercurialEclipse.utils.ClipboardUtils;
import com.vectrace.MercurialEclipse.wizards.ExportOptionsPage;
import com.vectrace.MercurialEclipse.wizards.ExportPage;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.TeamOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportWizard
extends HgWizard {
    private ExportPage sourcePage;
    private List<IResource> resources;
    private LocationChooser.Location location;
    private HgRoot root;
    private String result;
    private ArrayList<String> options;
    private ExportOptionsPage optionsPage;

    public ExportWizard(List<IResource> resources, HgRoot root) {
        super(Messages.getString("ExportWizard.WindowTitle"));
        this.setNeedsProgressMonitor(true);
        this.sourcePage = new ExportPage(resources, root);
        this.addPage((IWizardPage)this.sourcePage);
        this.initPage(Messages.getString("ExportWizard.pageDescription"), this.sourcePage);
        this.optionsPage = new ExportOptionsPage();
        this.addPage((IWizardPage)this.optionsPage);
        this.initPage(Messages.getString("ExportWizard.optionsPageDescription"), this.optionsPage);
        this.root = root;
    }

    @Override
    public boolean performFinish() {
        block4: {
            this.sourcePage.finish(null);
            try {
                this.resources = this.sourcePage.getCheckedResources();
                this.options = this.optionsPage.getOptions();
                this.location = this.sourcePage.getLocation();
                if (this.location.getLocationType() == LocationChooser.LocationType.Clipboard || !this.location.getFile().exists() || MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("ExportWizard.OverwriteConfirmTitle"), (String)Messages.getString("ExportWizard.OverwriteConfirmDescription"))) break block4;
                return false;
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(this.getWindowTitle(), e);
                MercurialEclipsePlugin.showError(e.getCause());
                return false;
            }
        }
        ExportOperation operation = new ExportOperation((IRunnableContext)this.getContainer());
        this.result = null;
        this.getContainer().run(true, false, (IRunnableWithProgress)operation);
        if (this.result != null) {
            this.optionsPage.setErrorMessage(this.result);
            return false;
        }
        return true;
    }

    public void doExport() throws Exception {
        if (this.location.getLocationType() == LocationChooser.LocationType.Clipboard) {
            ClipboardUtils.copyToClipboard(HgPatchClient.exportPatch(this.root, this.resources, this.options));
        } else {
            HgPatchClient.exportPatch(this.root, this.resources, this.location.getFile(), this.options);
        }
        if (this.location.getLocationType() == LocationChooser.LocationType.Workspace) {
            this.location.getWorkspaceFile().refreshLocal(0, null);
        }
    }

    class ExportOperation
    extends TeamOperation {
        public ExportOperation(IRunnableContext context) {
            super(context);
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("ExportWizard.pageTitle"), 1);
            try {
                try {
                    ExportWizard.this.doExport();
                }
                catch (Exception e) {
                    ExportWizard.this.result = e.getLocalizedMessage();
                    MercurialEclipsePlugin.logError(String.valueOf(Messages.getString("ExportWizard.pageTitle")) + " failed:", e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

