/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgIdentClient;
import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalChangesetCache
extends AbstractCache {
    private static final MercurialStatusCache STATUS_CACHE = MercurialStatusCache.getInstance();
    private static LocalChangesetCache instance = null;
    private static Map<IPath, ReentrantLock> locks = new HashMap<IPath, ReentrantLock>();
    private static Map<IPath, SortedSet<ChangeSet>> localChangeSets;

    private LocalChangesetCache() {
        localChangeSets = new HashMap<IPath, SortedSet<ChangeSet>>();
    }

    private boolean isGetFileInformationForChangesets() {
        return Boolean.valueOf(HgClients.getPreference("hg.performance.fileShowsChangeset", "false"));
    }

    public static LocalChangesetCache getInstance() {
        if (instance == null) {
            instance = new LocalChangesetCache();
        }
        return instance;
    }

    public synchronized void clear() {
        localChangeSets.clear();
        locks.clear();
    }

    public void clear(IResource objectResource) throws HgException {
        ReentrantLock lock = this.getLock(objectResource);
        try {
            lock.lock();
            Set<IResource> members = this.getMembers(objectResource);
            members.add(objectResource);
            for (IResource resource : members) {
                localChangeSets.remove(resource.getLocation());
            }
            this.notifyChanged(objectResource);
        }
        finally {
            lock.unlock();
        }
    }

    public SortedSet<ChangeSet> getLocalChangeSets(IResource objectResource) throws HgException {
        ReentrantLock lock = this.getLock(objectResource);
        try {
            lock.lock();
            SortedSet<ChangeSet> revisions = localChangeSets.get(objectResource.getLocation());
            if (revisions == null && (objectResource.getType() == 1 || objectResource.getType() == 4 && STATUS_CACHE.isSupervised(objectResource) && !STATUS_CACHE.isAdded((IResource)objectResource.getProject(), objectResource.getLocation()))) {
                this.refreshAllLocalRevisions(objectResource);
                revisions = localChangeSets.get(objectResource.getLocation());
            }
            if (revisions != null) {
                SortedSet<ChangeSet> sortedSet = Collections.unmodifiableSortedSet(revisions);
                return sortedSet;
            }
            return null;
        }
        finally {
            lock.unlock();
        }
    }

    public ChangeSet getNewestLocalChangeSet(IResource objectResource) throws HgException {
        ReentrantLock lock = this.getLock(objectResource);
        try {
            lock.lock();
            SortedSet<ChangeSet> revisions = this.getLocalChangeSets(objectResource);
            if (revisions != null && revisions.size() > 0) {
                ChangeSet changeSet = revisions.last();
                return changeSet;
            }
            return null;
        }
        finally {
            lock.unlock();
        }
    }

    public ReentrantLock getLock(IResource objectResource) throws HgException {
        try {
            Path hgRoot = objectResource.isAccessible() ? new Path(MercurialTeamProvider.getHgRoot(objectResource).getAbsolutePath()) : new Path(objectResource.getProject().getLocation().toOSString());
            ReentrantLock lock = locks.get(hgRoot);
            if (lock == null) {
                lock = new ReentrantLock();
                locks.put((IPath)hgRoot, lock);
            }
            return lock;
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public boolean isLocallyKnown(IResource objectResource) throws HgException {
        ReentrantLock lock = this.getLock(objectResource);
        try {
            lock.lock();
            boolean bl = localChangeSets.containsKey(objectResource.getLocation());
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void refreshAllLocalRevisions(IResource res) throws HgException {
        this.refreshAllLocalRevisions(res, true);
    }

    public void refreshAllLocalRevisions(IResource res, boolean limit) throws HgException {
        this.refreshAllLocalRevisions(res, limit, this.isGetFileInformationForChangesets());
    }

    public void refreshAllLocalRevisions(IResource res, boolean limit, boolean withFiles) throws HgException {
        Assert.isNotNull((Object)res);
        if (RepositoryProvider.getProvider((IProject)res.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && res.getProject().isOpen()) {
            int defaultLimit = this.getLogBatchSize();
            this.refreshAllLocalRevisions(res, limit, defaultLimit, withFiles);
        }
    }

    public int getLogBatchSize() {
        int defaultLimit = 2000;
        String pref = HgClients.getPreference("hg.batchsize.log", String.valueOf(defaultLimit));
        try {
            defaultLimit = Integer.parseInt(pref);
            if (defaultLimit < 0) {
                throw new NumberFormatException(Messages.getString("LocalChangesetCache.LogLimitLessThanZero"));
            }
        }
        catch (NumberFormatException e) {
            MercurialEclipsePlugin.logWarning(Messages.getString("LocalChangesetCache.LogLimitNotCorrectlyConfigured"), e);
        }
        return defaultLimit;
    }

    public ChangeSet getLocalChangeSet(IResource res, String nodeId) throws HgException {
        return this.getLocalChangeSet(res, nodeId, true);
    }

    public ChangeSet getLocalChangeSet(IResource res, String nodeId, boolean redecorate) throws HgException {
        Assert.isNotNull((Object)res);
        Assert.isNotNull((Object)nodeId);
        if (STATUS_CACHE.isSupervised(res)) {
            ReentrantLock lock = this.getLock(res);
            try {
                lock.lock();
                ChangeSet changeSet = this.getChangeSet(nodeId);
                if (changeSet == null) {
                    changeSet = HgLogClient.getChangeset(res, nodeId, this.isGetFileInformationForChangesets());
                }
                TreeSet<ChangeSet> set = new TreeSet<ChangeSet>();
                if (changeSet != null) {
                    set.add(changeSet);
                    this.addToNodeMap(set);
                }
                ChangeSet changeSet2 = changeSet;
                return changeSet2;
            }
            finally {
                lock.unlock();
                if (redecorate) {
                    this.notifyChanged(res);
                }
            }
        }
        return null;
    }

    public ChangeSet getCurrentWorkDirChangeset(IResource res) throws HgException {
        try {
            HgRoot root = HgClients.getHgRoot(res.getLocation().toFile());
            String nodeId = HgIdentClient.getCurrentChangesetId(root);
            if (nodeId != null && !nodeId.equals("0000000000000000000000000000000000000000")) {
                return this.getLocalChangeSet(res, nodeId, false);
            }
        }
        catch (IOException e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
        return null;
    }

    public void refreshAllLocalRevisions(IResource res, boolean limit, int limitNumber, boolean withFiles) throws HgException {
        this.refreshAllLocalRevisions(res, limit, limitNumber, -1, withFiles);
    }

    public void refreshAllLocalRevisions(IResource res, boolean limit, int limitNumber, int startRev, boolean withFiles) throws HgException {
        Assert.isNotNull((Object)res);
        if (RepositoryProvider.getProvider((IProject)res.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && res.getProject().isOpen()) {
            if (!STATUS_CACHE.isSupervised(res)) {
                return;
            }
            ReentrantLock lock = this.getLock(res);
            try {
                try {
                    lock.lock();
                    Map<IPath, SortedSet<ChangeSet>> revisions = null;
                    revisions = limit ? HgLogClient.getProjectLog(res, limitNumber, startRev, withFiles) : HgLogClient.getCompleteProjectLog(res, withFiles);
                    HashSet<IPath> paths = new HashSet<IPath>();
                    IResource[] localMembers = STATUS_CACHE.getLocalMembers(res);
                    IResource[] iResourceArray = localMembers;
                    int n = localMembers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        paths.add(resource.getLocation());
                        ++n2;
                    }
                    HashSet<IPath> concernedPaths = new HashSet<IPath>();
                    File root = HgRootClient.getHgRootAsFile(res);
                    if (revisions != null && revisions.size() > 0) {
                        concernedPaths.add(res.getLocation());
                        concernedPaths.addAll(paths);
                        if (res.getType() == 4) {
                            concernedPaths.addAll(revisions.keySet());
                        } else {
                            Path path = new Path(root.getCanonicalPath());
                            localChangeSets.put(res.getLocation(), revisions.get(path));
                        }
                        for (Map.Entry entry : revisions.entrySet()) {
                            IResource myResource;
                            IPath path = (IPath)entry.getKey();
                            SortedSet<ChangeSet> changes = (SortedSet<ChangeSet>)entry.getValue();
                            if (changes == null && limit && withFiles && STATUS_CACHE.isSupervised((IResource)res.getProject(), path) && !STATUS_CACHE.isAdded((IResource)res.getProject(), path) && (myResource = super.convertRepoRelPath(root, res.getProject(), path.toOSString())) != null) {
                                changes = HgLogClient.getRecentProjectLog(myResource, 1, withFiles).get(path);
                            }
                            this.addChangesToLocalCache(path, changes);
                        }
                    }
                }
                catch (IOException e) {
                    MercurialEclipsePlugin.logError(e);
                    throw new HgException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                lock.unlock();
                this.notifyChanged(res);
            }
        }
    }

    private void addChangesToLocalCache(IPath path, SortedSet<ChangeSet> changes) {
        if (changes != null && changes.size() > 0) {
            SortedSet<ChangeSet> existing = localChangeSets.get(path);
            if (existing == null) {
                existing = new TreeSet<ChangeSet>();
            }
            existing.addAll(changes);
            localChangeSets.put(path, existing);
            this.addToNodeMap(changes);
        }
    }

    public boolean isLocalUpdateInProgress(IResource res) throws HgException {
        return this.getLock(res).isLocked();
    }

    public SortedSet<ChangeSet> getLocalChangeSetsByBranch(IProject project, String branchName) throws HgException {
        ReentrantLock lock = this.getLock((IResource)project);
        try {
            lock.lock();
            SortedSet<ChangeSet> changes = this.getLocalChangeSets((IResource)project);
            TreeSet<ChangeSet> branchChangeSets = new TreeSet<ChangeSet>();
            for (ChangeSet changeSet : changes) {
                if (!changeSet.getBranch().equals(branchName) && (!branchName.equals("default") || !changeSet.getBranch().equals(""))) continue;
                branchChangeSets.add(changeSet);
            }
            TreeSet<ChangeSet> treeSet = branchChangeSets;
            return treeSet;
        }
        finally {
            lock.unlock();
        }
    }
}

