/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.actions.AddToWorkspaceAction;
import com.vectrace.MercurialEclipse.commands.HgPathsClient;
import com.vectrace.MercurialEclipse.team.Messages;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.TeamException;

public class MercurialProjectSetCapability
extends ProjectSetCapability {
    private static MercurialProjectSetCapability instance;

    public String[] asReference(IProject[] providerProjects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        try {
            String[] references = new String[providerProjects.length];
            monitor.beginTask(Messages.getString("MercurialProjectSetCapability.determiningProjectReferences"), providerProjects.length);
            int i = 0;
            while (i < providerProjects.length) {
                String reference = this.asReference(null, providerProjects[i].getName());
                if (monitor.isCanceled() || reference == null) {
                    String msg = monitor.isCanceled() ? Messages.getString("MercurialProjectSetCapability.cancelled") : String.valueOf(Messages.getString("MercurialProjectSetCapability.notDeterminable")) + providerProjects[i];
                    throw new TeamException(msg);
                }
                references[i] = reference;
                ++i;
            }
            String[] stringArray = references;
            return stringArray;
        }
        finally {
            monitor.done();
        }
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        AddToWorkspaceAction action = new AddToWorkspaceAction();
        action.setReferenceStrings(referenceStrings);
        try {
            action.run(monitor);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("MercurialProjectSetCapability.errorWhileImporting"), (String)e.getMessage());
        }
        return action.getProjectsCreated();
    }

    public String asReference(URI uri, String projectName) {
        String reference = null;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projectName);
            String srcRepository = "";
            Map<String, String> locs = HgPathsClient.getPaths(project);
            srcRepository = locs.containsKey("default-pull") ? locs.get("default-pull") : (locs.containsKey("default") ? locs.get("default") : project.getLocation().toFile().getAbsolutePath());
            if (srcRepository != null && srcRepository.length() > 0) {
                reference = "MercurialEclipseProjectSet_" + project.getName() + "_" + srcRepository;
            }
        }
        catch (CoreException coreException) {}
        return reference;
    }

    public String getProject(String referenceString) {
        return referenceString.split("_")[1];
    }

    public static ProjectSetCapability getInstance() {
        if (instance == null) {
            instance = new MercurialProjectSetCapability();
        }
        return instance;
    }
}

