/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgCatClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.utils.PatchUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IStorageMercurialRevision
implements IStorage {
    private String revision;
    private String global;
    private IResource resource;
    private ChangeSet changeSet;
    private HgRoot root;

    public IStorageMercurialRevision(IResource res, String changeset) {
        this.resource = res;
        try {
            ChangeSet cs;
            this.changeSet = cs = LocalChangesetCache.getInstance().getLocalChangeSet(res, changeset);
            this.revision = String.valueOf(cs.getChangesetIndex());
            this.global = cs.getChangeset();
        }
        catch (NumberFormatException e) {
            MercurialEclipsePlugin.logError(e);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
    }

    public IStorageMercurialRevision(IResource res, String rev, String global, ChangeSet cs) {
        this.revision = rev;
        this.global = global;
        this.resource = res;
        this.changeSet = cs;
    }

    public IStorageMercurialRevision(IResource res) {
        this.resource = res;
        ChangeSet cs = null;
        try {
            cs = LocalChangesetCache.getInstance().getCurrentWorkDirChangeset(res);
            this.revision = String.valueOf(cs.getChangesetIndex());
            this.global = cs.getChangeset();
            this.changeSet = cs;
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class)) {
            return this.resource;
        }
        return null;
    }

    public InputStream getContents() throws CoreException {
        String result = "";
        this.root = MercurialTeamProvider.getHgRoot(this.resource);
        IFile file = this.resource.getProject().getFile(this.resource.getProjectRelativePath());
        if (this.changeSet != null) {
            if (this.changeSet.getDirection() == ChangeSet.Direction.INCOMING && this.changeSet.getBundleFile() != null) {
                String bundleFile = null;
                try {
                    bundleFile = this.changeSet.getBundleFile().getCanonicalFile().getCanonicalPath();
                }
                catch (IOException e) {
                    MercurialEclipsePlugin.logError(e);
                    throw new CoreException((IStatus)new Status(4, "com.vectrace.MercurialEclipse", e.getMessage(), (Throwable)e));
                }
                if (bundleFile != null) {
                    result = HgCatClient.getContentFromBundle(file, String.valueOf(this.changeSet.getChangesetIndex()), bundleFile);
                }
            } else {
                if (this.changeSet.getDirection() == ChangeSet.Direction.OUTGOING) {
                    return PatchUtils.getPatchedContents(file, this.changeSet.getPatches(), true);
                }
                result = HgCatClient.getContent(file, String.valueOf(this.changeSet.getChangesetIndex()));
            }
        } else {
            result = HgCatClient.getContent(file, null);
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(result.getBytes(this.root.getEncoding().name()));
            return is;
        }
        catch (UnsupportedEncodingException e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public IPath getFullPath() {
        return this.resource.getFullPath().append(this.revision != null ? " [" + this.revision + "]" : Messages.getString("IStorageMercurialRevision.parentChangeset"));
    }

    public String getName() {
        String name = this.changeSet != null ? String.valueOf(this.resource.getName()) + " [" + this.changeSet.toString() + "]" : this.resource.getName();
        return name;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean isReadOnly() {
        if (this.revision != null) {
            return true;
        }
        ResourceAttributes attributes = this.resource.getResourceAttributes();
        if (attributes != null) {
            return attributes.isReadOnly();
        }
        return true;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getGlobal() {
        return this.global;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public IStorageMercurialRevision(IResource res, int rev) {
        this(res, String.valueOf(rev));
    }
}

