/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.storage;

import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.DataLoader;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class FileDataLoader
extends DataLoader {
    private IFile file;

    public FileDataLoader(IFile file) {
        this.file = file;
    }

    public IProject getProject() {
        return this.file.getProject();
    }

    public ChangeSet[] getRevisions() throws HgException {
        LocalChangesetCache.getInstance().refreshAllLocalRevisions((IResource)this.file, false);
        SortedSet<ChangeSet> csSet = LocalChangesetCache.getInstance().getLocalChangeSets((IResource)this.file);
        if (IncomingChangesetCache.getInstance().isIncomingStatusKnown(this.getProject())) {
            SortedSet<ChangeSet> incomingChangeSets = IncomingChangesetCache.getInstance().getIncomingChangeSets((IResource)this.file);
            csSet.addAll(incomingChangeSets);
        }
        ChangeSet[] changeSetArray = csSet.toArray(new ChangeSet[csSet.size()]);
        Collections.reverse(Arrays.asList(changeSetArray));
        this.changeSets = changeSetArray;
        return this.changeSets;
    }
}

