/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.storage;

import com.vectrace.MercurialEclipse.commands.HgBranchClient;
import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.commands.HgParentClient;
import com.vectrace.MercurialEclipse.commands.HgTagClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Branch;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.Tag;
import org.eclipse.core.resources.IProject;

public abstract class DataLoader {
    ChangeSet[] changeSets;

    public abstract IProject getProject();

    public abstract ChangeSet[] getRevisions() throws HgException;

    public Tag[] getTags() throws HgException {
        return HgTagClient.getTags(this.getProject());
    }

    public Branch[] getBranches() throws HgException {
        return HgBranchClient.getBranches(this.getProject());
    }

    public ChangeSet[] getHeads() throws HgException {
        return HgLogClient.getHeads(this.getProject());
    }

    public int[] getParents() throws HgException {
        return HgParentClient.getParents(this.getProject());
    }

    public ChangeSet getChangeSetByRevision(int revision) {
        ChangeSet[] changeSetArray = this.changeSets;
        int n = this.changeSets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet changeSet = changeSetArray[n2];
            if (changeSet.getRevision().getRevision() == revision) {
                return changeSet;
            }
            ++n2;
        }
        return null;
    }

    public ChangeSet searchChangeSet(String tagOrNode) {
        ChangeSet[] changeSetArray = this.changeSets;
        int n = this.changeSets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet changeSet = changeSetArray[n2];
            if (changeSet.getTag().equals(tagOrNode) || changeSet.getChangeset().equals(tagOrNode) || changeSet.getNodeShort().equals(tagOrNode)) {
                return changeSet;
            }
            ++n2;
        }
        return null;
    }

    public ChangeSet getChangeSetByTag(Tag tag) {
        int i = 0;
        while (i < this.changeSets.length) {
            ChangeSet cs = this.changeSets[i];
            if (cs.getTag().equals(tag.getName()) || cs.getChangeset().equals(tag.getGlobalId()) || cs.getChangesetIndex() == tag.getRevision()) {
                return cs;
            }
            if (cs.getChangesetIndex() > tag.getRevision()) {
                if (i > 0) {
                    return this.changeSets[i - 1];
                }
                return this.changeSets[0];
            }
            ++i;
        }
        return null;
    }
}

