/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.preferences;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.preferences.MercurialPreferenceConstants;
import com.vectrace.MercurialEclipse.preferences.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected static final int DEFAULT_COMMIT_MESSAGE_BATCH_SIZE = 10;

    public GeneralPreferencePage() {
        super(1);
        this.setPreferenceStore(MercurialEclipsePlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("GeneralPreferencePage.description"));
    }

    public void createFieldEditors() {
        MercurialExecutableFileFieldEditor execField = new MercurialExecutableFileFieldEditor("hg", Messages.getString("GeneralPreferencePage.field.hgExecutable"), this.getFieldEditorParent());
        this.addField((FieldEditor)execField);
        if (!MercurialEclipsePlugin.getDefault().isHgUsable()) {
            execField.setErrorMessage(Messages.getString("GeneralPreferencePage.error.HgNotInstalled"));
        }
        this.addField((FieldEditor)new GpgExecutableFileFieldEditor("hg.gpg.executable", Messages.getString("GeneralPreferencePage.field.gpgExecutable"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("user.name", Messages.getString("GeneralPreferencePage.field.username"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("hg.merge.useExternal", Messages.getString("GeneralPreferencePage.useExternalMergeTool"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelDecoratorRadioGroupFieldEditor("hg.labeldecorator.logic", Messages.getString("GeneralPreferencePage.field.decorationGroup.description"), 1, new String[][]{{Messages.getString("GeneralPreferencePage.field.decorationGroup.asModified"), "2-means-modified"}, {Messages.getString("GeneralPreferencePage.field.decorationGroup.mostImportant"), "high-bit"}}, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new BooleanFieldEditor("hg.labeldecorator.colors", Messages.getString("GeneralPreferencePage.enableFontAndColorDecorations"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(MercurialPreferenceConstants.PREF_AUTO_SHARE_PROJECTS, Messages.getString("GeneralPreferencePage.autoshare"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new CommitMessageBatchSizeIntegerFieldEditor("hg.batchsize.commitmessage", Messages.getString("GeneralPreferencePage.field.commitMessageBatchSize"), this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    private final class CommitMessageBatchSizeIntegerFieldEditor
    extends IntegerFieldEditor {
        private CommitMessageBatchSizeIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        public void load() {
            super.load();
            if (this.getIntValue() <= 0) {
                super.setPresentsDefaultValue(true);
                super.setStringValue(String.valueOf(10));
            }
        }
    }

    private final class GpgExecutableFileFieldEditor
    extends FileFieldEditor {
        private GpgExecutableFileFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            return "hg.gpg.executable".equals(this.getTextControl().getText()) || super.checkState();
        }
    }

    private final class LabelDecoratorRadioGroupFieldEditor
    extends RadioGroupFieldEditor {
        private LabelDecoratorRadioGroupFieldEditor(String name, String labelText, int numColumns, String[][] labelAndValues, Composite parent, boolean useGroup) {
            super(name, labelText, numColumns, labelAndValues, parent, useGroup);
        }

        protected void doStore() {
            super.doStore();
            MercurialEclipsePlugin.getDefault().checkHgInstallation();
        }
    }

    private final class MercurialExecutableFileFieldEditor
    extends FileFieldEditor {
        private MercurialExecutableFileFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            return "hg".equals(this.getTextControl().getText()) || super.checkState();
        }
    }
}

