/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgIdentClient;
import com.vectrace.MercurialEclipse.commands.HgPatchClient;
import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.commands.HgUpdateClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgAtticClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.operations.Messages;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IWorkbenchPart;

public class ShelveOperation
extends HgOperation {
    private IProject project;

    public ShelveOperation(IWorkbenchPart part, IProject p) {
        super(part);
        this.project = p;
    }

    public ShelveOperation(IRunnableContext context, IProject p) {
        super(context);
        this.project = p;
    }

    public ShelveOperation(IWorkbenchPart part, IRunnableContext context, IProject p) {
        super(part, context);
        this.project = p;
    }

    protected String getActionDescription() {
        return Messages.getString("ShelveOperation.shelvingChanges");
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(Messages.getString("ShelveOperation.shelving"), 5);
                if (MercurialUtilities.isCommandAvailable("resolve", ResourceProperties.RESOLVE_AVAILABLE, "") && MercurialUtilities.isCommandAvailable("attic-shelve", ResourceProperties.EXT_HGATTIC_AVAILABLE, "")) {
                    String output = HgAtticClient.shelve(this.project.getLocation().toFile(), "MercurialEclipse shelve operation", true, MercurialUtilities.getHGUsername(), this.project.getName());
                    monitor.worked(1);
                    this.project.refreshLocal(2, monitor);
                    monitor.worked(1);
                    HgClients.getConsole().printMessage(output, null);
                } else {
                    monitor.subTask(Messages.getString("ShelveOperation.determiningChanges"));
                    String[] dirtyFiles = HgStatusClient.getDirtyFiles(this.project.getLocation().toFile());
                    ArrayList<IResource> resources = new ArrayList<IResource>();
                    HgRoot root = HgClients.getHgRoot(this.project.getLocation().toFile());
                    String[] stringArray = dirtyFiles;
                    int n = dirtyFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        IResource r = MercurialStatusCache.getInstance().convertRepoRelPath(root, this.project, f.substring(2));
                        if (r.exists()) {
                            resources.add(r);
                        }
                        ++n2;
                    }
                    if (resources.size() == 0) {
                        throw new HgException(Messages.getString("ShelveOperation.error.nothingToShelve"));
                    }
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("ShelveOperation.shelvingChanges"));
                    File shelveDir = new File(root, ".hg" + File.separator + "mercurialeclipse-shelve-backups");
                    shelveDir.mkdir();
                    File shelveFile = new File(shelveDir, this.project.getName().concat("-patchfile.patch"));
                    if (shelveFile.exists()) {
                        throw new HgException(Messages.getString("ShelveOperation.error.shelfNotEmpty"));
                    }
                    HgPatchClient.exportPatch(root, resources, shelveFile, new ArrayList<String>(0));
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("ShelveOperation.determiningCurrentChangeset"));
                    String currRev = HgIdentClient.getCurrentChangesetId(root);
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("ShelveOperation.cleaningDirtyFiles"));
                    HgUpdateClient.update(this.project, currRev, true);
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("ShelveOperation.refreshingResources"));
                    for (IResource resource : resources) {
                        resource.refreshLocal(0, monitor);
                    }
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
                throw new InvocationTargetException(e, e.getLocalizedMessage());
            }
        }
        finally {
            monitor.done();
        }
    }
}

