/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.core.RepositoryProvider;

public class CreateProjectOperation
extends HgOperation {
    private File projectFile;
    private HgRepositoryLocation repo;
    private boolean readProjectFile;
    private String projectName;
    private IProject project;
    private File projectDirectory;

    public CreateProjectOperation(IRunnableContext context, File projectDirectory, File projectFile, HgRepositoryLocation repo, boolean readProjectFile, String projectName) {
        super(context);
        this.projectFile = projectFile;
        this.repo = repo;
        this.readProjectFile = readProjectFile;
        this.projectName = projectName;
        this.projectDirectory = projectDirectory;
    }

    protected String getActionDescription() {
        return Messages.getString("CreateProjectOperation.taskDescription");
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.createProject(monitor);
            monitor.done();
        }
        catch (HgException e1) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e1));
            throw new InvocationTargetException((Throwable)((Object)e1));
        }
    }

    private void createProject(IProgressMonitor monitor) throws HgException {
        InputStream in;
        block18: {
            in = null;
            if (!monitor.isCanceled()) break block18;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProjectDescription projectDesc = null;
                monitor.beginTask(Messages.getString("CreateProjectOperation.beginTask"), 15);
                if (this.readProjectFile && this.projectFile != null) {
                    monitor.subTask(Messages.getString("CreateProjectOperation.subTaskReadingProjectFile"));
                    in = new FileInputStream(this.projectFile);
                    projectDesc = workspace.loadProjectDescription(in);
                    monitor.worked(1);
                } else {
                    monitor.subTask(Messages.getString("CreateProjectOperation.subTaskCreatingProjectFile"));
                    projectDesc = workspace.newProjectDescription(this.projectName);
                    projectDesc.setComment(String.valueOf(Messages.getString("CloneRepoWizard.description.comment")) + this.repo);
                    monitor.worked(1);
                }
                if (!workspace.getRoot().getLocation().toFile().getAbsolutePath().equals(this.projectDirectory.getParentFile().getAbsolutePath())) {
                    projectDesc.setLocation((IPath)new Path(this.projectDirectory.getAbsolutePath()));
                } else {
                    projectDesc.setLocation(null);
                }
                IProject p = workspace.getRoot().getProject(projectDesc.getName());
                p.create(projectDesc, monitor);
                p.open(monitor);
                this.registerWithTeamProvider(p, monitor);
                this.project = p;
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
                throw new HgException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void registerWithTeamProvider(IProject p, IProgressMonitor monitor) throws HgException {
        try {
            monitor.subTask(String.valueOf(Messages.getString("CloneRepoWizard.subTask.registeringProject1")) + p.getName() + Messages.getString("CloneRepoWizard.subTaskRegisteringProject2"));
            RepositoryProvider.map((IProject)p, (String)MercurialTeamProvider.class.getName());
            monitor.worked(1);
            monitor.subTask(String.valueOf(Messages.getString("CloneRepoWizard.subTask.addingRepository.1")) + this.repo + Messages.getString("CloneRepoWizard.subTask.addingRepository.2"));
            MercurialEclipsePlugin.getRepoManager().addRepoLocation(p, this.repo);
            monitor.worked(1);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getMessage(), e);
        }
    }

    public IProject getProject() {
        return this.project;
    }
}

