/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.extensions.HgBookmarkClient;
import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.ui.BookmarkTable;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class BookmarkDialog
extends TrayDialog {
    private IProject project;
    private ChangesetTable csTable;
    private Button revCheckBox;
    private Text bmNameTextBox;
    private Button createButton;
    private Button renameCheckBox;
    private BookmarkTable bookmarkTable;
    private Text newBmNameTextBox;
    private Button deleteCheckBox;
    private boolean modifyTab = false;
    private Label renameLabel;

    public BookmarkDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.project = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("BookmarkDialog.shell.text"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 1);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        TabFolder tabFolder = new TabFolder(composite, 4);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCreateTabItem(tabFolder);
        this.createModifyTabItem(tabFolder);
        return composite;
    }

    protected TabItem createCreateTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, folder.getStyle());
        item.setText(Messages.getString("BookmarkDialog.createTab.name"));
        Composite c = SWTWidgetHelper.createComposite((Composite)folder, 2);
        GridData layoutData = new GridData(4, 4, true, true);
        c.setLayoutData((Object)layoutData);
        item.setControl((Control)c);
        Listener tabSl = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 22) {
                    BookmarkDialog.this.modifyTab = false;
                }
            }
        };
        item.addListener(22, tabSl);
        Group tipGroup = SWTWidgetHelper.createGroup(c, Messages.getString("BookmarkDialog.createGroup.label"));
        SWTWidgetHelper.createLabel((Composite)tipGroup, Messages.getString("BookmarkDialog.bookmarkName"));
        this.bmNameTextBox = SWTWidgetHelper.createTextField((Composite)tipGroup);
        Group revGroup = SWTWidgetHelper.createGroup(c, Messages.getString("BookmarkDialog.selectRevision"));
        revGroup.setLayoutData((Object)layoutData);
        this.csTable = new ChangesetTable((Composite)revGroup, (IResource)this.project, true);
        this.csTable.setLayoutData(layoutData);
        this.csTable.setEnabled(true);
        SelectionListener sl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                BookmarkDialog.this.modifyTab = false;
            }
        };
        this.csTable.addSelectionListener(sl);
        return item;
    }

    protected TabItem createModifyTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, folder.getStyle());
        item.setText(Messages.getString("BookmarkDialog.modifyTab.name"));
        Composite c = SWTWidgetHelper.createComposite((Composite)folder, 2);
        GridData layoutData = new GridData(4, 4, true, true);
        c.setLayoutData((Object)layoutData);
        item.setControl((Control)c);
        Listener tabSl = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 22) {
                    BookmarkDialog.this.modifyTab = true;
                }
            }
        };
        item.addListener(22, tabSl);
        Group selGroup = SWTWidgetHelper.createGroup(c, Messages.getString("BookmarkDialog.selectBookmark"));
        selGroup.setLayoutData((Object)layoutData);
        this.bookmarkTable = new BookmarkTable((Composite)selGroup, (IResource)this.project);
        this.bookmarkTable.setLayoutData(layoutData);
        SelectionListener sl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                BookmarkDialog.this.modifyTab = true;
            }
        };
        this.bookmarkTable.addSelectionListener(sl);
        Group renameGroup = SWTWidgetHelper.createGroup(c, Messages.getString("BookmarkDialog.renameGroup.label"));
        this.deleteCheckBox(SWTWidgetHelper.createCheckBox((Composite)renameGroup, Messages.getString("BookmarkDialog.option.delete")));
        SelectionListener delSl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selection = BookmarkDialog.this.deleteCheckBox.getSelection();
                if (selection) {
                    BookmarkDialog.this.renameCheckBox.setSelection(false);
                    BookmarkDialog.this.renameLabel.setEnabled(false);
                    BookmarkDialog.this.bmNameTextBox.setEnabled(false);
                    BookmarkDialog.this.modifyTab = true;
                }
            }
        };
        this.deleteCheckBox.addSelectionListener(delSl);
        this.renameCheckBox = SWTWidgetHelper.createCheckBox((Composite)renameGroup, Messages.getString("BookmarkDialog.option.rename"));
        this.renameLabel = SWTWidgetHelper.createLabel((Composite)renameGroup, Messages.getString("BookmarkDialog.newName"));
        this.newBmNameTextBox = SWTWidgetHelper.createTextField((Composite)renameGroup);
        this.newBmNameTextBox.setEnabled(false);
        this.renameLabel.setEnabled(false);
        SelectionListener renSl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selection = BookmarkDialog.this.renameCheckBox.getSelection();
                if (selection) {
                    BookmarkDialog.this.deleteCheckBox.setSelection(false);
                    BookmarkDialog.this.modifyTab = true;
                }
                BookmarkDialog.this.renameLabel.setEnabled(selection);
                BookmarkDialog.this.newBmNameTextBox.setEnabled(selection);
            }
        };
        this.renameCheckBox.addSelectionListener(renSl);
        return item;
    }

    protected void okPressed() {
        try {
            if (!this.modifyTab) {
                String targetRev = "tip";
                if (this.csTable.getSelection() != null) {
                    targetRev = this.csTable.getSelection().getChangeset();
                }
                HgBookmarkClient.create(this.project.getLocation().toFile(), this.bmNameTextBox.getText(), targetRev);
            } else if (this.renameCheckBox.getSelection()) {
                HgBookmarkClient.rename(this.project.getLocation().toFile(), this.bookmarkTable.getSelection().getName(), this.newBmNameTextBox.getText());
            } else if (this.deleteCheckBox.getSelection()) {
                HgBookmarkClient.delete(this.project.getLocation().toFile(), this.bookmarkTable.getSelection().getName());
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            MercurialEclipsePlugin.showError((Throwable)((Object)e));
        }
        super.okPressed();
    }

    public IProject getProject() {
        return this.project;
    }

    public ChangesetTable getCsTable() {
        return this.csTable;
    }

    public Button getRevCheckBox() {
        return this.revCheckBox;
    }

    public Text getBmNameTextBox() {
        return this.bmNameTextBox;
    }

    public Button getCreateButton() {
        return this.createButton;
    }

    public Button getRenameCheckBox() {
        return this.renameCheckBox;
    }

    public BookmarkTable getBookmarkTable() {
        return this.bookmarkTable;
    }

    public void deleteCheckBox(Button deleteCheckBox) {
        this.deleteCheckBox = deleteCheckBox;
    }

    public Button getDeleteCheckBox() {
        return this.deleteCheckBox;
    }
}

