/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions.forest;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class HgFpushPullClient
extends AbstractClient {
    public static String fpush(File forestRoot, HgRepositoryLocation repo, String revision, int timeout, File snapFile) throws HgException {
        try {
            URI uri;
            HgCommand command = new HgCommand("fpush", forestRoot, true);
            command.setUsePreferenceTimeout("hg.timeout.push");
            if (snapFile != null) {
                command.addOptions("--snapfile", snapFile.getCanonicalPath());
            }
            if (revision != null && revision.length() > 0) {
                command.addOptions("-r", revision.trim());
            }
            if ((uri = repo.getUri()) != null) {
                command.addOptions(uri.toASCIIString());
            } else {
                command.addOptions(repo.getLocation());
            }
            return new String(command.executeToBytes(timeout));
        }
        catch (IOException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public static String fpull(File forestRoot, HgRepositoryLocation repo, boolean update, boolean timeout, ChangeSet changeset, boolean walkHg, File snapFile, boolean partial) throws HgException {
        URI uri = repo.getUri();
        String pullSource = uri != null ? uri.toASCIIString() : repo.getLocation();
        return HgFpushPullClient.fpull(forestRoot, update, timeout, changeset, walkHg, snapFile, partial, pullSource);
    }

    public static String fpull(File forestRoot, boolean update, boolean timeout, ChangeSet changeset, boolean walkHg, File snapFile, boolean partial, String pullSource) throws HgException {
        try {
            HgCommand command = new HgCommand("fpull", forestRoot, true);
            if (update) {
                command.addOptions("--update");
            }
            if (changeset != null) {
                command.addOptions("--rev", changeset.getChangeset());
            }
            if (snapFile != null) {
                command.addOptions("--snapfile", snapFile.getCanonicalPath());
            }
            if (walkHg) {
                command.addOptions("--walkhg", "true");
            }
            if (partial) {
                command.addOptions("--partial");
            }
            command.addOptions(pullSource);
            if (timeout) {
                command.setUsePreferenceTimeout("hg.timeout.pull");
                return new String(command.executeToBytes());
            }
            return new String(command.executeToBytes(Integer.MAX_VALUE));
        }
        catch (IOException e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }
}

