/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;

public class HgRootClient {
    private static final Map<String, File> roots = new HashMap<String, File>();

    public static String getHgRoot(IResource resource) throws HgException {
        return HgRootClient.getHgRoot2(resource);
    }

    private static String getHgRoot2(IResource resource) throws HgException {
        File root = HgRootClient.getHgRootAsFile(resource);
        try {
            return root.getCanonicalPath();
        }
        catch (IOException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public static File getHgRootAsFile(IResource resource) throws HgException {
        File root = resource.getLocation().toFile();
        root = HgRootClient.getHgRoot(root);
        return root;
    }

    public static File getHgRoot(File file) throws HgException {
        String canonicalPath = null;
        try {
            canonicalPath = file.getCanonicalPath();
            if (!file.isDirectory()) {
                canonicalPath = file.getParentFile().getCanonicalPath();
            }
            if (roots.containsKey(canonicalPath)) {
                return roots.get(canonicalPath);
            }
        }
        catch (IOException iOException) {
            throw new HgException(String.valueOf(Messages.getString("HgRootClient.error.cannotGetCanonicalPath")) + file.getName());
        }
        File root = file;
        if (root.isFile()) {
            root = root.getParentFile();
        }
        FilenameFilter hg = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(".hg");
            }
        };
        if (root != null) {
            String[] rootContent = root.list(hg);
            while (rootContent != null && rootContent.length < 1) {
                if ((root = root.getParentFile()) == null) break;
                rootContent = root.list(hg);
            }
        }
        if (root == null) {
            throw new HgException(String.valueOf(file.getName()) + Messages.getString("HgRootClient.error.noRoot"));
        }
        roots.put(canonicalPath, root);
        return root;
    }
}

