/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.IConfiguration;
import com.vectrace.MercurialEclipse.commands.IConsole;
import com.vectrace.MercurialEclipse.commands.IErrorHandler;
import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.model.HgRoot;
import java.io.File;
import java.io.IOException;

public final class HgClients {
    private static IConsole console;
    private static IConfiguration config;
    private static IErrorHandler error;

    public static void initialize(IConsole c, IErrorHandler errorHandler, IConfiguration configuration) {
        config = configuration;
        console = c;
        error = errorHandler;
    }

    public static String getExecutable() {
        if (config == null) {
            throw new IllegalStateException(Messages.getString("HgClients.error.notInitializedWithConfig"));
        }
        return config.getExecutable();
    }

    public static String getDefaultUserName() {
        if (config == null) {
            throw new IllegalStateException(Messages.getString("HgClients.error.notInitializedWithConfig"));
        }
        return config.getDefaultUserName();
    }

    public static IConsole getConsole() {
        if (console == null) {
            throw new IllegalStateException(Messages.getString("HgClients.error.notInitializedWithConsole"));
        }
        return console;
    }

    public static void logError(IOException e) {
        error.logError(e);
    }

    public static void logWarning(String message, Throwable e) {
        error.logWarning(message, e);
        MercurialEclipsePlugin.logWarning(message, e);
    }

    public static int getTimeOut(String commandId) {
        return config.getTimeOut(commandId);
    }

    public static String getPreference(String preferenceConstant, String defaultIfNotSet) {
        return config.getPreference(preferenceConstant, defaultIfNotSet);
    }

    public static HgRoot getHgRoot(File file) {
        return config.getHgRoot(file);
    }
}

