/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.ICopyable;
import org.eclipse.equinox.internal.p2.ui.model.ProfileSnapshots;
import org.eclipse.equinox.internal.p2.ui.model.RollbackProfileElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.InstalledIUGroup;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.RepositoryContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.menus.AbstractContributionFactory;

public class RevertProfilePage
extends InstallationPage
implements ICopyable {
    private static final int REVERT_ID = 1024;
    private static final int DEFAULT_COLUMN_WIDTH = 150;
    TableViewer configsViewer;
    TreeViewer configContentsViewer;
    IUDetailsLabelProvider labelProvider;
    IAction revertAction;
    Button revertButton;
    String profileId;
    AbstractContributionFactory factory;
    Text detailsArea;
    InstalledIUGroup installedIUGroup;

    public void createPageButtons(Composite parent) {
        if (this.profileId == null) {
            return;
        }
        this.revertButton = this.createButton(parent, 1024, this.revertAction.getText());
        this.revertButton.setEnabled(this.revertAction.isEnabled());
    }

    public void createControl(Composite parent) {
        this.profileId = Policy.getDefault().getProfileChooser().getProfileId(ProvUI.getDefaultParentShell());
        if (this.profileId == null) {
            IStatus status = Policy.getDefault().getNoProfileChosenStatus();
            if (status != null) {
                ProvUI.reportStatus(status, 1);
            }
            Text text = new Text(parent, 72);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(ProvUIMessages.RevertProfilePage_NoProfile);
            this.setControl((Control)text);
            return;
        }
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.equinox.p2.ui.revert_configuration_wizard_context");
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gd);
        this.createConfigurationsSection((Composite)sashForm);
        this.createContentsSection((Composite)sashForm);
        this.setControl((Control)sashForm);
        this.createRevertAction();
        Object element = this.configsViewer.getElementAt(0);
        if (element != null) {
            this.configsViewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private void createConfigurationsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigsLabel);
        this.configsViewer = new TableViewer(composite, 68352);
        this.configsViewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ProvElementLabelProvider());
        this.configsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof RollbackProfileElement && o2 instanceof RollbackProfileElement) {
                    long timestamp2;
                    long timestamp1 = ((RollbackProfileElement)o1).getTimestamp();
                    if (timestamp1 > (timestamp2 = ((RollbackProfileElement)o2).getTimestamp())) {
                        return -1;
                    }
                    return 1;
                }
                return o2.toString().compareTo(o1.toString());
            }
        });
        this.configsViewer.setInput(this.getInput());
        this.configsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevertProfilePage.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        CopyUtils.activateCopy(this, this.configsViewer.getControl());
        gd = new GridData(4, 4, true, true);
        this.configsViewer.getControl().setLayoutData((Object)gd);
    }

    private void createContentsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigContentsLabel);
        this.configContentsViewer = new TreeViewer(composite, 68354);
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(ProvUI.getIUColumnConfig());
        this.configContentsViewer.setComparator((ViewerComparator)comparator);
        this.configContentsViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.configContentsViewer.setContentProvider((IContentProvider)new DeferredQueryContentProvider());
        this.setTreeColumns(this.configContentsViewer.getTree());
        this.labelProvider = new IUDetailsLabelProvider();
        this.configContentsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        gd = new GridData(1808);
        this.configContentsViewer.getControl().setLayoutData((Object)gd);
        CopyUtils.activateCopy(this, this.configContentsViewer.getControl());
    }

    private void createRevertAction() {
        this.revertAction = new Action(){

            public void run() {
                boolean result = MessageDialog.openQuestion((Shell)RevertProfilePage.this.getShell(), (String)ProvUIMessages.RevertDialog_Title, (String)ProvUIMessages.RevertDialog_ConfirmRestartMessage);
                if (!result) {
                    return;
                }
                boolean finish = RevertProfilePage.this.revert();
                if (finish) {
                    RevertProfilePage.this.getPageContainer().closeModalContainers();
                }
            }
        };
        this.revertAction.setText(ProvUIMessages.RevertProfilePage_RevertLabel);
        this.revertAction.setToolTipText(ProvUIMessages.RevertProfilePage_RevertTooltip);
    }

    private Object getInput() {
        ProfileSnapshots element = new ProfileSnapshots(this.profileId);
        return element;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.revertAction.run();
            }
        }
    }

    void handleSelectionChanged(IStructuredSelection selection) {
        Object selected;
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof RollbackProfileElement) {
            Object[] elements = this.configContentsViewer.getExpandedElements();
            this.configContentsViewer.getTree().setRedraw(false);
            this.configContentsViewer.setInput(selected);
            this.configContentsViewer.setExpandedElements(elements);
            this.configContentsViewer.getTree().setRedraw(true);
            this.revertAction.setEnabled(!((RollbackProfileElement)selected).isCurrentProfile());
            if (this.revertButton != null) {
                this.revertButton.setEnabled(this.revertAction.isEnabled());
            }
            return;
        }
        this.configContentsViewer.setInput(null);
        this.revertAction.setEnabled(false);
        if (this.revertButton != null) {
            this.revertButton.setEnabled(false);
        }
    }

    private void setTreeColumns(Tree tree) {
        IUColumnConfig[] columns = ProvUI.getIUColumnConfig();
        tree.setHeaderVisible(true);
        int i = 0;
        while (i < columns.length) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setResizable(true);
            tc.setText(columns[i].columnTitle);
            tc.setWidth(this.convertHorizontalDLUsToPixels(150));
            ++i;
        }
    }

    private IProfile getSelectedSnapshot() {
        Object selected = ((IStructuredSelection)this.configsViewer.getSelection()).getFirstElement();
        if (selected != null && selected instanceof RollbackProfileElement) {
            try {
                return ((RollbackProfileElement)selected).getProfileSnapshot((IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProvisionException e) {
                ProvUI.handleException(e, null, 1);
            }
        }
        return null;
    }

    boolean revert() {
        final IProfile snapshot = this.getSelectedSnapshot();
        if (snapshot == null) {
            return false;
        }
        final ProvisioningPlan[] plan = new ProvisioningPlan[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    IProfile currentProfile = ProvisioningUtil.getProfile(RevertProfilePage.this.profileId);
                    plan[0] = ProvisioningUtil.getRevertPlan(currentProfile, snapshot, monitor);
                }
                catch (ProvisionException e) {
                    ProvUI.handleException(e, null, 3);
                }
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException(e.getCause(), null, 3);
        }
        catch (InterruptedException interruptedException) {}
        if (dialog.getProgressMonitor().isCanceled()) {
            return false;
        }
        boolean reverted = false;
        if (plan[0] != null) {
            if (plan[0].getStatus().isOK()) {
                ProfileModificationOperation op = new ProfileModificationOperation(ProvUIMessages.RevertDialog_RevertOperationLabel, this.profileId, plan[0], new ProvisioningContext(), (PhaseSet)new DefaultPhaseSet(), true);
                ProvisioningOperationRunner.schedule(op, 3);
                ProvisioningOperationRunner.requestRestart(true);
                reverted = true;
            } else if (plan[0].getStatus().getSeverity() != 8) {
                ProvUI.reportStatus(plan[0].getStatus(), 3);
            }
        }
        return reverted;
    }

    public void copyToClipboard(Control activeControl) {
        String text = "";
        if (activeControl == this.configContentsViewer.getControl()) {
            text = CopyUtils.getIndentedClipboardText(((IStructuredSelection)this.configContentsViewer.getSelection()).toArray(), this.labelProvider);
        } else if (activeControl == this.configsViewer.getControl()) {
            Object[] elements = ((IStructuredSelection)this.configsViewer.getSelection()).toArray();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof RollbackProfileElement) {
                    if (i > 0) {
                        buffer.append(CopyUtils.NEWLINE);
                    }
                    buffer.append(((RollbackProfileElement)elements[i]).getLabel(elements[i]));
                }
                ++i;
            }
            text = buffer.toString();
        } else {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }
}

