/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.extensions.HgStripClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class StripWizardPage
extends HgWizardPage {
    private ChangesetTable changesetTable;
    private Button unrelatedCheckBox;
    protected ChangeSet stripRevision;
    private IProject project;
    private Button backupCheckBox;
    private Button stripHeadsCheckBox;
    private boolean unrelated;
    private boolean stripHeads;
    private boolean backup;

    public StripWizardPage(String pageName, String title, ImageDescriptor image, IProject project) {
        super(pageName, title, image);
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        Group changeSetGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("StripWizardPage.changeSetGroup.title"), 1808);
        this.changesetTable = new ChangesetTable((Composite)changeSetGroup, (IResource)this.project);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.minimumHeight = 50;
        this.changesetTable.setLayoutData(gridData);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StripWizardPage.this.stripRevision = StripWizardPage.this.changesetTable.getSelection();
                StripWizardPage.this.setPageComplete(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.changesetTable.addSelectionListener(listener);
        this.changesetTable.setEnabled(true);
        Group optionGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("StripWizardPage.optionsGroup.title"));
        this.unrelatedCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("StripWizardPage.unrelatedCheckBox.title"));
        this.unrelatedCheckBox.setSelection(true);
        this.backupCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("StripWizardPage.backupCheckBox.title"));
        this.backupCheckBox.setSelection(true);
        this.stripHeadsCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("StripWizardPage.stripHeadsCheckBox.title"));
        this.setControl((Control)composite);
    }

    public boolean finish(IProgressMonitor monitor) {
        super.finish(monitor);
        this.stripRevision = this.changesetTable.getSelection();
        this.unrelated = this.unrelatedCheckBox.getSelection();
        this.stripHeads = this.stripHeadsCheckBox.getSelection();
        this.backup = this.backupCheckBox.getSelection();
        try {
            String result = HgStripClient.strip(this.project, this.unrelated, this.backup, this.stripHeads, this.stripRevision);
            HgClients.getConsole().printMessage(result, null);
        }
        catch (HgException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("StripWizardPage.errorCallingStrip"), (String)e.getMessage());
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            return false;
        }
        return true;
    }
}

