/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.wizards.OutgoingPage;
import com.vectrace.MercurialEclipse.wizards.PushPullPage;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushRepoPage
extends PushPullPage {
    public PushRepoPage(String pageName, String title, ImageDescriptor titleImage, IResource resource) {
        super(resource, pageName, title, titleImage);
        this.showRevisionTable = false;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    @Override
    public boolean finish(IProgressMonitor monitor) {
        this.force = this.forceCheckBox.getSelection();
        this.timeout = this.timeoutCheckBox.getSelection();
        return super.finish(monitor);
    }

    @Override
    public boolean canFlipToNextPage() {
        try {
            if (this.getUrlCombo().getText() != null && this.getUrlCombo().getText() != null) {
                OutgoingPage outgoingPage = (OutgoingPage)this.getNextPage();
                outgoingPage.setProject(this.resource.getProject());
                HgRepositoryLocation loc = MercurialEclipsePlugin.getRepoManager().getRepoLocation(this.urlCombo.getText(), this.getUserCombo().getText(), this.getPasswordText().getText());
                outgoingPage.setLocation(loc);
                outgoingPage.setSvn(this.getSvnCheckBox() != null && this.getSvnCheckBox().getSelection());
                this.setErrorMessage(null);
                return this.isPageComplete() && this.getWizard().getNextPage((IWizardPage)this) != null;
            }
        }
        catch (URISyntaxException e) {
            this.setErrorMessage(e.getLocalizedMessage());
        }
        return false;
    }

    @Override
    protected Set<HgRepositoryLocation> setDefaultLocation() {
        HgRepositoryLocation defaultLocation = null;
        Set<HgRepositoryLocation> repos = super.setDefaultLocation();
        if (repos == null) {
            return null;
        }
        for (HgRepositoryLocation repo : repos) {
            if (!"default-push".equals(repo.getLogicalName()) && !"default".equals(repo.getLogicalName())) continue;
            defaultLocation = repo;
            break;
        }
        if (defaultLocation == null) {
            defaultLocation = MercurialEclipsePlugin.getRepoManager().getDefaultProjectRepoLocation(this.resource.getProject());
        }
        if (defaultLocation != null) {
            String password;
            this.getUrlCombo().setText(defaultLocation.getLocation());
            String user = defaultLocation.getUser();
            if (user != null && user.length() != 0) {
                this.getUserCombo().setText(user);
            }
            if ((password = defaultLocation.getPassword()) != null && password.length() != 0) {
                this.getPasswordText().setText(password);
            }
        }
        return repos;
    }
}

