/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.commands.HgPushPullClient;
import com.vectrace.MercurialEclipse.commands.HgResolveClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgSvnClient;
import com.vectrace.MercurialEclipse.commands.extensions.forest.HgFpushPullClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.CommitMergeHandler;
import com.vectrace.MercurialEclipse.menu.MergeHandler;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.FlaggedAdaptable;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.IncomingPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.PullPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class PullRepoWizard
extends HgWizard {
    private boolean doUpdate;
    private PullPage pullPage;
    private IncomingPage incomingPage;
    private IResource resource;
    private HgRepositoryLocation repo;

    public PullRepoWizard(IResource resource) {
        super(Messages.getString("PullRepoWizard.title"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.pullPage = new PullPage(Messages.getString("PullRepoWizard.pullPage.name"), Messages.getString("PullRepoWizard.pullPage.title"), Messages.getString("PullRepoWizard.pullPage.description"), (IResource)this.resource.getProject(), null);
        this.initPage(this.pullPage.getDescription(), this.pullPage);
        this.addPage((IWizardPage)this.pullPage);
        this.incomingPage = new IncomingPage(Messages.getString("PullRepoWizard.incomingPage.name"));
        this.initPage(this.incomingPage.getDescription(), this.incomingPage);
        this.addPage((IWizardPage)this.incomingPage);
    }

    public boolean performFinish() {
        if (this.resource.getProject().getLocation() == null) {
            return false;
        }
        this.pullPage.finish((IProgressMonitor)new NullProgressMonitor());
        this.incomingPage.finish((IProgressMonitor)new NullProgressMonitor());
        this.repo = this.getLocation();
        try {
            this.doUpdate = this.pullPage.getUpdateCheckBox().getSelection();
            boolean force = this.pullPage.getForceCheckBox().getSelection();
            ChangeSet cs = null;
            if (this.incomingPage.getRevisionCheckBox().getSelection()) {
                cs = this.incomingPage.getRevision();
            }
            boolean timeout = this.pullPage.getTimeoutCheckBox().getSelection();
            boolean merge = this.pullPage.getMergeCheckBox().getSelection();
            boolean rebase = false;
            Button rebase_button = this.pullPage.getRebaseCheckBox();
            if (rebase_button != null) {
                rebase = rebase_button.getSelection();
            }
            boolean showCommitDialog = this.pullPage.getCommitDialogCheckBox().getSelection();
            boolean svn = false;
            if (this.pullPage.isShowSvn()) {
                svn = this.pullPage.getSvnCheckBox().getSelection();
            }
            boolean forest = false;
            File snapFile = null;
            if (this.pullPage.isShowForest()) {
                forest = this.pullPage.getForestCheckBox().getSelection();
                String snapFileText = this.pullPage.getSnapFileCombo().getText();
                if (snapFileText.length() > 0) {
                    snapFile = new File(snapFileText);
                }
            }
            File bundleFile = null;
            if (this.incomingPage.getChangesets() != null && this.incomingPage.getChangesets().size() > 0) {
                bundleFile = this.incomingPage.getChangesets().first().getBundleFile();
            }
            PullOperation pullOperation = new PullOperation((IRunnableContext)this.getContainer(), this.doUpdate, this.resource, force, this.repo, cs, timeout, merge, showCommitDialog, bundleFile, forest, snapFile, rebase, svn);
            this.getContainer().run(true, false, (IRunnableWithProgress)pullOperation);
            String output = pullOperation.getOutput();
            if (output.length() != 0) {
                HgClients.getConsole().printMessage(output, null);
            }
            IncomingChangesetCache.getInstance().clear(this.repo);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            MercurialEclipsePlugin.showError(e.getCause());
            return false;
        }
        return true;
    }

    private HgRepositoryLocation getLocation() {
        try {
            return MercurialEclipsePlugin.getRepoManager().fromProperties(this.pullPage.getProperties());
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("PullRepoWizard.malformedURL"), (String)e.getMessage());
            MercurialEclipsePlugin.logInfo(e.getMessage(), e);
            return null;
        }
    }

    private class PullOperation
    extends HgOperation {
        private boolean doUpdate;
        private IResource resource;
        private HgRepositoryLocation repo;
        private boolean force;
        private ChangeSet pullRevision;
        private boolean timeout;
        private boolean merge;
        private String output;
        private boolean showCommitDialog;
        private File bundleFile;
        private boolean forest;
        private File snapFile;
        private boolean rebase;
        private boolean svn;

        public PullOperation(IRunnableContext context, boolean doUpdate, IResource resource, boolean force, HgRepositoryLocation repo, ChangeSet pullRevision, boolean timeout, boolean merge, boolean showCommitDialog, File bundleFile, boolean forest, File snapFile, boolean rebase, boolean svn) {
            super(context);
            this.output = "";
            this.doUpdate = doUpdate;
            this.resource = resource;
            this.force = force;
            this.repo = repo;
            this.pullRevision = pullRevision;
            this.timeout = timeout;
            this.merge = merge;
            this.showCommitDialog = showCommitDialog;
            this.bundleFile = bundleFile;
            this.forest = forest;
            this.snapFile = snapFile;
            this.rebase = rebase;
            this.svn = svn;
        }

        protected String getActionDescription() {
            return Messages.getString("PullRepoWizard.pullOperation.description");
        }

        private String performMerge(IProgressMonitor monitor) throws HgException, PartInitException, CoreException, InterruptedException {
            String r = Messages.getString("PullRepoWizard.pullOperation.mergeHeader");
            monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.merging"));
            if (HgLogClient.getHeads(this.resource.getProject()).length > 1) {
                SafeUiJob job = new SafeUiJob(Messages.getString("PullRepoWizard.pullOperation.mergeJob.description")){

                    protected IStatus runSafe(IProgressMonitor m) {
                        try {
                            String res = MergeHandler.merge(PullOperation.this.resource, PullOperation.this.getShell());
                            return new Status(0, "com.vectrace.MercurialEclipse", res);
                        }
                        catch (Exception e) {
                            MercurialEclipsePlugin.logError(e);
                            return new Status(4, "com.vectrace.MercurialEclipse", e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                };
                job.schedule();
                job.join();
                IStatus jobResult = job.getResult();
                if (jobResult.getSeverity() == 0) {
                    r = String.valueOf(r) + jobResult.getMessage();
                } else {
                    throw new HgException(jobResult.getMessage(), jobResult.getException());
                }
            }
            monitor.worked(1);
            return r;
        }

        private String performPull(HgRepositoryLocation repository, IProgressMonitor monitor) throws InvocationTargetException {
            try {
                monitor.worked(1);
                monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.incoming"));
                String r = Messages.getString("PullRepoWizard.pullOperation.pull.header");
                if (this.svn) {
                    r = String.valueOf(r) + HgSvnClient.pull(this.resource.getLocation().toFile());
                    if (this.rebase) {
                        r = String.valueOf(r) + HgSvnClient.rebase(this.resource.getLocation().toFile());
                    }
                } else if (this.bundleFile == null) {
                    if (this.forest) {
                        File forestRoot = MercurialTeamProvider.getHgRoot(this.resource.getLocation().toFile()).getParentFile();
                        r = String.valueOf(r) + HgFpushPullClient.fpull(forestRoot, this.repo, this.doUpdate, this.timeout, this.pullRevision, true, this.snapFile, false);
                    } else {
                        r = String.valueOf(r) + HgPushPullClient.pull(this.resource, this.repo, this.doUpdate, this.force, this.timeout, this.pullRevision, this.rebase);
                    }
                } else {
                    r = String.valueOf(r) + HgPushPullClient.pull(this.resource, this.doUpdate, this.force, this.timeout, this.pullRevision, this.bundleFile.getCanonicalPath(), this.rebase);
                }
                monitor.worked(1);
                monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.refresh.description"));
                IncomingChangesetCache.getInstance().clear();
                LocalChangesetCache.getInstance().clear((IResource)this.resource.getProject());
                LocalChangesetCache.getInstance().refreshAllLocalRevisions((IResource)this.resource.getProject());
                monitor.worked(1);
                monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.status"));
                this.saveRepo(monitor);
                return r;
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(Messages.getString("PullRepoWizard.pullOperationFailed"), e);
                throw new InvocationTargetException(e, e.getMessage());
            }
        }

        private boolean saveRepo(IProgressMonitor monitor) {
            try {
                monitor.subTask(String.valueOf(Messages.getString("PullRepoWizard.pullOperation.addRepo")) + this.repo);
                MercurialEclipsePlugin.getRepoManager().addRepoLocation(this.resource.getProject(), this.repo);
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError(Messages.getString("PullRepoWizard.addingRepositoryFailed"), (Throwable)((Object)e));
            }
            monitor.worked(1);
            return true;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask(Messages.getString("PullRepoWizard.pullOperation.pulling"), 6);
                this.output = String.valueOf(this.output) + this.performPull(this.repo, monitor);
                if (this.merge) {
                    String mergeResult = this.performMerge(monitor);
                    this.output = String.valueOf(this.output) + mergeResult;
                    this.commitMerge(monitor, mergeResult);
                }
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
                throw new InvocationTargetException(e, e.getMessage());
            }
            monitor.done();
        }

        private void commitMerge(IProgressMonitor monitor, String mergeResult) throws HgException, CoreException, InterruptedException {
            if (this.resource != null && this.resource.getProject() != null && this.resource.getProject().getPersistentProperty(ResourceProperties.MERGING) != null) {
                boolean commit = true;
                if (!HgResolveClient.checkAvailable()) {
                    if (!mergeResult.contains("all conflicts resolved")) {
                        commit = false;
                    }
                } else {
                    List<FlaggedAdaptable> mergeAdaptables = HgResolveClient.list(this.resource);
                    monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.mergeStatus"));
                    for (FlaggedAdaptable flaggedAdaptable : mergeAdaptables) {
                        if (flaggedAdaptable.getFlag() != 'U') continue;
                        commit = false;
                        break;
                    }
                    monitor.worked(1);
                }
                if (commit) {
                    monitor.subTask(Messages.getString("PullRepoWizard.pullOperation.commit"));
                    this.output = String.valueOf(this.output) + Messages.getString("PullRepoWizard.pullOperation.commit.header");
                    if (!this.showCommitDialog) {
                        this.output = String.valueOf(this.output) + CommitMergeHandler.commitMerge(this.resource);
                    } else {
                        SafeUiJob job = new SafeUiJob(Messages.getString("PullRepoWizard.pullOperation.commitJob.description")){

                            protected IStatus runSafe(IProgressMonitor moni) {
                                try {
                                    String res = new CommitMergeHandler().commitMergeWithCommitDialog(PullOperation.this.resource, PullOperation.this.getShell());
                                    return new Status(0, "com.vectrace.MercurialEclipse", res);
                                }
                                catch (HgException e) {
                                    MercurialEclipsePlugin.logError((Throwable)((Object)e));
                                    return new Status(4, "com.vectrace.MercurialEclipse", e.getLocalizedMessage(), (Throwable)((Object)e));
                                }
                            }
                        };
                        job.schedule();
                        job.join();
                        IStatus jobResult = job.getResult();
                        if (jobResult.getSeverity() == 0) {
                            this.output = String.valueOf(this.output) + jobResult.getMessage();
                        } else {
                            throw new HgException(jobResult.getMessage(), jobResult.getException());
                        }
                    }
                    monitor.worked(1);
                }
            }
        }

        public String getOutput() {
            return this.output;
        }
    }
}

