/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.views.console;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.views.console.HgConsole;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;

public class HgConsoleHolder
implements IConsoleListener,
IPropertyChangeListener {
    private static final HgConsoleHolder instance = new HgConsoleHolder();
    private HgConsole console;

    private HgConsoleHolder() {
    }

    public static HgConsoleHolder getInstance() {
        return instance;
    }

    private void init() {
        if (!this.isInitialized()) {
            Font f = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("hg.console.font");
            this.console = new HgConsole();
            this.console.setFont(f);
            this.console.initialize();
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            MercurialEclipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private boolean isInitialized() {
        return this.console != null;
    }

    public HgConsole showConsole() {
        boolean showOnMessage;
        IConsole[] existing = this.getConsoleManager().getConsoles();
        boolean exists = false;
        int i = 0;
        while (i < existing.length) {
            if (this.console == existing[i]) {
                exists = true;
            }
            ++i;
        }
        if (!exists) {
            this.getConsoleManager().addConsoles(new IConsole[]{this.console});
        }
        if (showOnMessage = Boolean.parseBoolean(MercurialUtilities.getPreference("hg.console.showOnMessage", "false"))) {
            this.getConsoleManager().showConsoleView((IConsole)this.console);
        }
        return this.console;
    }

    public void closeConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        if (this.console != null) {
            manager.removeConsoles(new IConsole[]{this.console});
        }
    }

    public HgConsole getConsole() {
        this.init();
        return this.console;
    }

    public void consolesAdded(IConsole[] consoles) {
        int i = 0;
        while (i < consoles.length) {
            IConsole c = consoles[i];
            if (this.console == c) {
                this.console.init();
                this.showConsole();
                break;
            }
            ++i;
        }
    }

    public void consolesRemoved(IConsole[] consoles) {
        int i = 0;
        while (i < consoles.length) {
            IConsole c = consoles[i];
            if (c == this.console) {
                this.console.dispose();
                this.console = null;
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
                MercurialEclipsePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
                break;
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.console.propertyChange(event);
    }

    private IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }
}

