/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniFile {
    Map<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();

    public IniFile() {
    }

    public IniFile(String filename) throws FileNotFoundException {
        this();
        this.load(filename);
    }

    public IniFile(URL url) throws IOException {
        this();
        this.load(url.openStream());
    }

    public IniFile(InputStream input) throws IOException {
        this();
        this.load(input);
    }

    public void setKeyValue(String section, String key, String value) {
        try {
            this.getSection(section).put(key.toLowerCase(), value);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Map<String, String>> getSections() {
        return this.sections;
    }

    public Map<String, String> getSection(String section) {
        return this.sections.get(section.toLowerCase());
    }

    public boolean isNullOrEmpty(String section, String key) {
        String value = this.getKeyValue(section, key);
        return value == null || value.length() == 0;
    }

    public String getKeyValue(String section, String key) {
        try {
            return this.getSection(section).get(key.toLowerCase());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getKeyIntValue(String section, String key) {
        return this.getKeyIntValue(section, key, 0);
    }

    public int getKeyIntValue(String section, String key, int defaultValue) {
        String value = this.getKeyValue(section, key.toLowerCase());
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void load(String filename) throws FileNotFoundException {
        this.load(new FileInputStream(filename));
    }

    public void save(String filename) throws IOException {
        this.save(new FileOutputStream(filename));
    }

    public void load(InputStream in) {
        try {
            String read;
            BufferedReader input = new BufferedReader(new InputStreamReader(in));
            Map<String, String> section = null;
            while ((read = input.readLine()) != null) {
                if (read.startsWith(";") || read.startsWith("#")) continue;
                if (read.startsWith("[")) {
                    String section_name = read.substring(1, read.indexOf("]")).toLowerCase();
                    section = this.sections.get(section_name);
                    if (section != null) continue;
                    section = new HashMap<String, String>();
                    this.sections.put(section_name, section);
                    continue;
                }
                if (read.indexOf("=") == -1 || section == null) continue;
                String key = read.substring(0, read.indexOf("=")).trim().toLowerCase();
                String value = read.substring(read.indexOf("=") + 1).trim();
                section.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(OutputStream out) {
        try {
            PrintWriter output = new PrintWriter(out);
            for (String section : this.sections.keySet()) {
                output.println("[" + section + "]");
                for (Map.Entry<String, String> entry : this.getSection(section).entrySet()) {
                    output.println(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                }
            }
            output.flush();
            output.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSection(String section) {
        this.sections.put(section.toLowerCase(), new HashMap());
    }

    public void removeSection(String section) {
    }

    public static void main(String[] args) throws Exception {
        new IniFile().load(new FileInputStream(args[0]));
    }
}

