/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingChangesetCache
extends AbstractCache {
    private static OutgoingChangesetCache instance;
    private static Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> outgoingChangeSets;
    private static Map<IResource, ReentrantLock> locks;

    static {
        locks = new HashMap<IResource, ReentrantLock>();
    }

    private OutgoingChangesetCache() {
        outgoingChangeSets = new HashMap<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>>();
    }

    public static OutgoingChangesetCache getInstance() {
        if (instance == null) {
            instance = new OutgoingChangesetCache();
        }
        return instance;
    }

    public synchronized void clear(HgRepositoryLocation repo) {
        outgoingChangeSets.remove(repo);
    }

    public ReentrantLock getLock(IResource objectResource) {
        ReentrantLock lock = locks.get(objectResource.getProject());
        if (lock == null) {
            lock = new ReentrantLock();
            locks.put((IResource)objectResource.getProject(), lock);
        }
        return lock;
    }

    public ChangeSet getNewestOutgoingChangeSet(IResource resource, HgRepositoryLocation repositoryLocation) throws HgException {
        ReentrantLock lock = this.getLock(resource);
        if (lock.isLocked()) {
            lock.lock();
            lock.unlock();
        }
        if (MercurialStatusCache.getInstance().isSupervised(resource)) {
            Map<IPath, SortedSet<ChangeSet>> repoMap = outgoingChangeSets.get(repositoryLocation);
            SortedSet<ChangeSet> revisions = null;
            if (repoMap != null) {
                revisions = repoMap.get(resource.getLocation());
            }
            if (revisions != null && revisions.size() > 0) {
                return revisions.last();
            }
        }
        return null;
    }

    public SortedSet<ChangeSet> getOutgoingChangeSets(IResource objectResource, HgRepositoryLocation repositoryLocation) throws HgException {
        ReentrantLock lock = this.getLock(objectResource);
        if (lock.isLocked()) {
            lock.lock();
            lock.unlock();
        }
        Map<IPath, SortedSet<ChangeSet>> repoOutgoing = outgoingChangeSets.get(repositoryLocation);
        SortedSet<ChangeSet> revisions = null;
        if (repoOutgoing != null) {
            revisions = repoOutgoing.get(objectResource.getLocation());
        }
        if (revisions == null) {
            this.refreshOutgoingChangeSets(objectResource.getProject(), repositoryLocation);
            repoOutgoing = outgoingChangeSets.get(repositoryLocation);
            if (repoOutgoing != null) {
                revisions = repoOutgoing.get(objectResource.getLocation());
            }
        }
        if (revisions != null) {
            return Collections.unmodifiableSortedSet(outgoingChangeSets.get(repositoryLocation).get(objectResource.getLocation()));
        }
        return null;
    }

    public IResource[] getOutgoingMembers(IResource resource, HgRepositoryLocation repositoryLocation) {
        ReentrantLock lock = this.getLock(resource);
        if (lock.isLocked()) {
            lock.lock();
            lock.unlock();
        }
        Map<IPath, SortedSet<ChangeSet>> changeSets = outgoingChangeSets.get(repositoryLocation);
        Set<IResource> members = this.getMembers(resource, changeSets);
        return members.toArray(new IResource[members.size()]);
    }

    public void refreshOutgoingChangeSets(IProject project, HgRepositoryLocation repositoryLocation) throws HgException {
        Assert.isNotNull((Object)project);
        if (RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && project.isOpen()) {
            ReentrantLock lock = this.getLock((IResource)project);
            try {
                lock.lock();
                this.addResourcesToCache(project, repositoryLocation, outgoingChangeSets, ChangeSet.Direction.OUTGOING);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public synchronized void clear() {
        outgoingChangeSets.clear();
        locks.clear();
    }
}

