/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgResolveClient;
import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgIMergeClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.FlaggedAdaptable;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.operations.InitOperation;
import com.vectrace.MercurialEclipse.preferences.MercurialPreferenceConstants;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialStatusCache
extends AbstractCache
implements IResourceChangeListener {
    private static final int STATUS_BATCH_SIZE = 10;
    private static final int NUM_CHANGED_FOR_COMPLETE_STATUS = 50;
    public static final int BIT_IGNORE = 0;
    public static final int BIT_CLEAN = 1;
    public static final int BIT_DELETED = 2;
    public static final int BIT_REMOVED = 3;
    public static final int BIT_UNKNOWN = 4;
    public static final int BIT_ADDED = 5;
    public static final int BIT_MODIFIED = 6;
    public static final int BIT_IMPOSSIBLE = 7;
    public static final int BIT_CONFLICT = 8;
    public static final char CHAR_MODIFIED = 'M';
    public static final char CHAR_ADDED = 'A';
    public static final char CHAR_UNKNOWN = '?';
    public static final char CHAR_CLEAN = 'C';
    public static final char CHAR_IGNORED = 'I';
    public static final char CHAR_REMOVED = 'R';
    public static final char CHAR_DELETED = '!';
    protected int INTERESTING_CHANGES = 323840;
    private static final Object DUMMY = new Object();
    private final Map<IPath, BitSet> statusMap = new ConcurrentHashMap<IPath, BitSet>();
    private final Map<IProject, Object> knownStatus = new ConcurrentHashMap<IProject, Object>();
    private final Map<IProject, ReentrantLock> locks = new HashMap<IProject, ReentrantLock>();

    private MercurialStatusCache() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static final MercurialStatusCache getInstance() {
        return MercurialStatusCacheHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        this.statusMap.clear();
        this.knownStatus.clear();
        projectResources.clear();
        Map<IProject, ReentrantLock> map = this.locks;
        synchronized (map) {
            this.locks.clear();
        }
        MercurialStatusCache.getInstance().setChanged();
        MercurialStatusCache.getInstance().notifyObservers(this.knownStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReentrantLock getLock(IResource resource) throws HgException {
        if (!resource.isAccessible() || resource.isDerived() || resource.isLinked() || !MercurialUtilities.hgIsTeamProviderFor(resource, false)) {
            return new ReentrantLock();
        }
        Map<IProject, ReentrantLock> map = this.locks;
        synchronized (map) {
            ReentrantLock lock = this.locks.get(resource.getProject());
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(resource.getProject(), lock);
            }
            return lock;
        }
    }

    public boolean isStatusKnown(IProject project) throws HgException {
        ReentrantLock lock = this.getLock((IResource)project);
        try {
            lock.lock();
            boolean bl = this.knownStatus.containsKey(project);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public BitSet getStatus(IResource resource) throws HgException {
        ReentrantLock lock = this.getLock(resource);
        try {
            lock.lock();
            BitSet bitSet = this.statusMap.get(resource.getLocation());
            return bitSet;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isSupervised(IResource resource) throws HgException {
        return MercurialUtilities.hgIsTeamProviderFor(resource, false) && this.isSupervised((IResource)resource.getProject(), resource.getLocation());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupervised(IResource resource, IPath path) throws HgException {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)path);
        if (Team.isIgnoredHint((IResource)resource)) {
            return false;
        }
        ReentrantLock lock = this.getLock(resource);
        if (!resource.getProject().isAccessible() || RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") == null) return false;
        try {
            lock.lock();
            if (path.equals((Object)resource.getProject().getLocation())) {
                return true;
            }
            BitSet status = this.statusMap.get(path);
            if (status == null) return false;
            switch (status.length() - 1) {
                case 0: 
                case 4: {
                    boolean supervised;
                    File fileSystemResource = path.toFile();
                    if (!fileSystemResource.isDirectory() || status.length() <= 1) return false;
                    boolean bl = supervised = status.get(5) || status.get(1) || status.get(2) || status.get(6) || status.get(3);
                    return bl;
                }
            }
            return true;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean hasUncommittedChanges(IResource[] resources) throws HgException {
        if (resources != null && resources.length > 0) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                BitSet status = this.getStatus(resource);
                if (status.length() - 1 > 1) {
                    return true;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean isAdded(IResource resource, IPath path) throws HgException {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)path);
        if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null) {
            ReentrantLock lock = this.getLock(resource);
            try {
                lock.lock();
                BitSet status = this.statusMap.get(path);
                if (status != null) {
                    switch (status.length() - 1) {
                        case 5: {
                            File fileSystemResource = path.toFile();
                            if (fileSystemResource.isDirectory() && status.length() > 1) {
                                boolean supervised = status.get(1) || status.get(2) || status.get(6) || status.get(3) || status.get(8) || status.get(0);
                                boolean bl = !supervised;
                                return bl;
                            }
                            return true;
                        }
                    }
                    return false;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    public void refresh(IProject project) throws TeamException {
        this.refreshStatus((IResource)project, (IProgressMonitor)new NullProgressMonitor());
    }

    public void refreshStatus(IResource res, IProgressMonitor monitor) throws HgException {
        Assert.isNotNull((Object)res);
        if (monitor != null) {
            monitor.subTask(String.valueOf(Messages.getString("MercurialStatusCache.Refreshing")) + res.getName());
        }
        if (RepositoryProvider.getProvider((IProject)res.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && res.getProject().isOpen()) {
            Set<IResource> changed;
            if (res.isTeamPrivateMember() || res.isDerived()) {
                return;
            }
            ReentrantLock lock = this.getLock(res);
            try {
                lock.lock();
                IResource[] resources = this.getLocalMembers(res);
                if (monitor != null) {
                    monitor.worked(1);
                }
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    this.statusMap.remove(resource.getLocation());
                    ++n2;
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                this.statusMap.remove(res.getLocation());
                String output = HgStatusClient.getStatusWithoutIgnored(res);
                if (monitor != null) {
                    monitor.worked(1);
                }
                File root = AbstractClient.getHgRoot(res);
                changed = this.parseStatus(root, res, output);
                if (monitor != null) {
                    monitor.worked(1);
                }
                try {
                    String mergeNode = HgStatusClient.getMergeStatus(res);
                    res.getProject().setPersistentProperty(ResourceProperties.MERGING, mergeNode);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                catch (CoreException e) {
                    throw new HgException(Messages.getString("MercurialStatusCache.FailedToRefreshMergeStatus"), e);
                }
            }
            finally {
                lock.unlock();
            }
            this.notifyChanged(changed);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    private void checkForConflict(IResource res) throws HgException {
        List<FlaggedAdaptable> status = HgResolveClient.checkAvailable() ? HgResolveClient.list(res) : HgIMergeClient.getMergeStatus(res);
        for (FlaggedAdaptable flaggedAdaptable : status) {
            IFile file = (IFile)flaggedAdaptable.getAdapter(IFile.class);
            if (flaggedAdaptable.getFlag() == 'U') {
                this.addConflict((IResource)file);
                continue;
            }
            this.removeConflict((IResource)file);
        }
    }

    private Set<IResource> parseStatus(File root, IResource res, String output) throws HgException {
        if (res.getType() == 4) {
            this.knownStatus.put(res.getProject(), DUMMY);
        }
        IProject project = res.getProject();
        HashSet<IResource> changed = new HashSet<IResource>();
        Scanner scanner = new Scanner(output);
        while (scanner.hasNext()) {
            String status = scanner.next();
            String localName = scanner.nextLine().trim();
            IResource member = this.convertRepoRelPath(root, project, localName);
            if (member == null) continue;
            BitSet bitSet = new BitSet();
            if (Team.isIgnoredHint((IResource)member)) {
                bitSet.set(0);
            } else {
                bitSet.set(this.getBitIndex(status.charAt(0)));
                changed.add(member);
            }
            this.statusMap.put(member.getLocation(), bitSet);
            if (member.getType() == 1 && this.getBitIndex(status.charAt(0)) != 0 && !Team.isIgnoredHint((IResource)member)) {
                this.addToProjectResources(project, member);
            }
            changed.addAll(this.setStatusToAncestors(member, bitSet));
        }
        try {
            if (res.getProject().getPersistentProperty(ResourceProperties.MERGING) != null) {
                this.checkForConflict(res);
            }
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
        return changed;
    }

    private Set<IResource> setStatusToAncestors(IResource resource, BitSet resourceBitSet) {
        IProject project = resource.getProject();
        HashSet<IResource> ancestors = new HashSet<IResource>();
        boolean computeDeep = this.isComputeDeepStatus();
        boolean completeStatus = Boolean.valueOf(HgClients.getPreference("hg.performance.getStatusForCompleteRepository", "false"));
        IContainer parent = resource.getParent();
        while (parent != null && parent != resource.getProject().getParent()) {
            BitSet parentBitSet = this.statusMap.get(parent.getLocation());
            BitSet cloneBitSet = (BitSet)resourceBitSet.clone();
            if (parentBitSet != null) {
                if (resource.getType() != 4 && computeDeep && !completeStatus) {
                    MemberStatusVisitor visitor = new MemberStatusVisitor((IResource)parent, cloneBitSet);
                    try {
                        if (parent.isAccessible() && !parent.isDerived() && !parent.isTeamPrivateMember()) {
                            parent.accept((IResourceVisitor)visitor, 1, false);
                        }
                    }
                    catch (CoreException e) {
                        MercurialEclipsePlugin.logError(e);
                    }
                } else {
                    cloneBitSet.or(parentBitSet);
                }
            }
            this.statusMap.put(parent.getLocation(), cloneBitSet);
            ancestors.add((IResource)parent);
            this.addToProjectResources(project, (IResource)parent);
            parent = parent.getParent();
        }
        return ancestors;
    }

    private boolean isComputeDeepStatus() {
        boolean computeDeep = Boolean.valueOf(HgClients.getPreference("hg.performance.computeDeepStatus", "false"));
        return computeDeep;
    }

    public int getBitIndex(char status) {
        switch (status) {
            case '!': {
                return 2;
            }
            case 'R': {
                return 3;
            }
            case 'I': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case '?': {
                return 4;
            }
            case 'A': {
                return 5;
            }
            case 'M': {
                return 6;
            }
        }
        String msg = String.valueOf(Messages.getString("MercurialStatusCache.UnknownStatus")) + status + "'";
        MercurialEclipsePlugin.logWarning(msg, (Throwable)((Object)new HgException(msg)));
        return 7;
    }

    public char getStatusChar(int bitIndex) {
        switch (bitIndex) {
            case 2: {
                return '!';
            }
            case 3: {
                return 'R';
            }
            case 0: {
                return 'I';
            }
            case 1: {
                return 'C';
            }
            case 4: {
                return '?';
            }
            case 5: {
                return 'A';
            }
            case 6: {
                return 'M';
            }
        }
        String msg = String.valueOf(Messages.getString("MercurialStatusCache.UnknownStatus")) + bitIndex + "'";
        MercurialEclipsePlugin.logWarning(msg, (Throwable)((Object)new HgException(msg)));
        return '\u0007';
    }

    public char getStatusChar(IResource resource) throws HgException {
        BitSet status = this.getStatus(resource);
        char statusChar = this.getStatusChar(status.length() - 1);
        return statusChar;
    }

    public void refreshStatus(IProgressMonitor monitor) throws TeamException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.refreshStatus((IResource)project, monitor);
            ++n2;
        }
    }

    public boolean isStatusKnown(IResource resource) throws HgException {
        return this.getStatus(resource) != null;
    }

    public IProject[] getAllManagedProjects() {
        return this.knownStatus.keySet().toArray(new IProject[this.knownStatus.size()]);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            try {
                IResourceDelta delta = event.getDelta();
                final HashMap changed = new HashMap();
                final HashMap added = new HashMap();
                final HashMap removed = new HashMap();
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(removed, changed, added);
                delta.accept((IResourceDeltaVisitor)visitor);
                final IWorkspace workspace = ResourcesPlugin.getWorkspace();
                HashSet changedProjects = new HashSet(changed.keySet());
                changedProjects.addAll(added.keySet());
                changedProjects.addAll(removed.keySet());
                for (final IProject project : changedProjects) {
                    final IWorkspaceRunnable job = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                Set addedSet = (Set)added.get(project);
                                Set removedSet = (Set)removed.get(project);
                                Set changedSet = (Set)changed.get(project);
                                HashSet<IResource> resources = new HashSet<IResource>();
                                if (changedSet != null) {
                                    resources.addAll(changedSet);
                                }
                                if (addedSet != null) {
                                    resources.addAll(addedSet);
                                }
                                if (removedSet != null) {
                                    resources.addAll(removedSet);
                                }
                                if (resources.size() > 50) {
                                    monitor.beginTask(Messages.getString("MercurialStatusCache.RefreshingProjects"), 2);
                                    monitor.subTask(String.valueOf(Messages.getString("MercurialStatusCache.RefreshingProject")) + project.getName() + Messages.getString("MercurialStatusCache...."));
                                    MercurialStatusCache.this.refreshStatus((IResource)project, monitor);
                                    monitor.worked(1);
                                } else {
                                    monitor.beginTask(Messages.getString("MercurialStatusCache.RefreshingResources..."), 4);
                                    monitor.subTask(Messages.getString("MercurialStatusCache.RefreshingChangedResources..."));
                                    if (changedSet != null && changedSet.size() > 0) {
                                        MercurialStatusCache.this.refreshStatus(changedSet);
                                    }
                                    monitor.worked(1);
                                    monitor.subTask(Messages.getString("MercurialStatusCache.RefreshingAddedResources..."));
                                    if (addedSet != null && addedSet.size() > 0) {
                                        MercurialStatusCache.this.refreshStatus(addedSet);
                                    }
                                    monitor.worked(1);
                                }
                                monitor.subTask(Messages.getString("MercurialStatusCache.AddingResourcesForDecoratorUpdate..."));
                                monitor.worked(1);
                                monitor.subTask(Messages.getString("MercurialStatusCache.TriggeringDecoratorUpdate..."));
                                MercurialStatusCache.this.notifyChanged(resources);
                                monitor.worked(1);
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    final ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)project);
                    SafeWorkspaceJob wsJob = new SafeWorkspaceJob(Messages.getString("MercurialStatusCache.RefreshStatus...")){

                        protected IStatus runSafe(IProgressMonitor monitor) {
                            try {
                                workspace.run(job, rule, 1, monitor);
                            }
                            catch (CoreException e) {
                                MercurialEclipsePlugin.logError(e);
                                return new Status(4, "com.vectrace.MercurialEclipse", e.getLocalizedMessage(), (Throwable)e);
                            }
                            return super.runSafe(monitor);
                        }
                    };
                    wsJob.setRule(rule);
                    wsJob.schedule(200L);
                }
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
    }

    private void refreshStatus(Set<IResource> resources) throws HgException {
        if (resources == null) {
            return;
        }
        String pref = HgClients.getPreference("hg.batchsize.status", String.valueOf(10));
        int batchSize = 10;
        if (pref.length() > 0) {
            try {
                batchSize = Integer.parseInt(pref);
            }
            catch (NumberFormatException e) {
                MercurialEclipsePlugin.logWarning(Messages.getString("MercurialStatusCache.BatchSizeForStatusCommandNotCorrect."), e);
            }
        }
        ArrayList<IResource> currentBatch = new ArrayList<IResource>();
        Iterator<IResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            IResource resource = iterator.next();
            if (resource.getType() == 4) {
                try {
                    this.refreshStatus(resource, null);
                    continue;
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    throw new HgException(e.getMessage(), e);
                }
            }
            if (!resource.isTeamPrivateMember()) {
                currentBatch.add(resource);
            }
            if (currentBatch.size() % batchSize != 0 && iterator.hasNext()) continue;
            File root = AbstractClient.getHgRoot(resource);
            String output = HgStatusClient.getStatusWithoutIgnored(resource.getLocation().toFile(), currentBatch);
            this.parseStatus(root, resource, output);
            currentBatch.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] getLocalMembers(IResource resource) throws HgException {
        ReentrantLock lock = this.getLock(resource);
        try {
            lock.lock();
            HashSet<IResource> members = new HashSet<IResource>();
            switch (resource.getType()) {
                case 1: {
                    break;
                }
                case 4: {
                    Map map = projectResources;
                    synchronized (map) {
                        Set<IResource> resources = AbstractCache.projectResources.get(resource);
                        if (resources != null) {
                            members.addAll(resources);
                            members.remove(resource);
                        }
                        break;
                    }
                }
                case 2: {
                    for (IPath memberPath : new HashMap<IPath, BitSet>(this.statusMap).keySet()) {
                        IContainer container;
                        IResource foundMember;
                        if (memberPath.equals((Object)resource.getLocation()) || (foundMember = (container = (IContainer)resource).findMember(memberPath, false)) == null || !foundMember.getLocation().equals((Object)memberPath)) continue;
                        members.add(foundMember);
                    }
                    break;
                }
            }
            members.remove(resource);
            IResource[] iResourceArray = members.toArray(new IResource[members.size()]);
            return iResourceArray;
        }
        finally {
            lock.unlock();
        }
    }

    public void clear(IProject project) throws HgException {
        ReentrantLock lock = this.getLock((IResource)project);
        try {
            lock.lock();
            Set<IResource> members = this.getMembers((IResource)project);
            for (IResource resource : members) {
                this.statusMap.remove(resource.getLocation());
            }
            this.statusMap.remove(project.getLocation());
        }
        finally {
            lock.unlock();
        }
    }

    public void addConflict(IResource local) throws HgException {
        BitSet status = this.getStatus(local);
        status.set(8);
        this.setStatusToAncestors(local, status);
        this.notifyChanged(local);
    }

    public void removeConflict(IResource local) throws HgException {
        BitSet status = this.getStatus(local);
        status.clear(8);
        this.setStatusToAncestors(local, status);
        this.notifyChanged(local);
    }

    @Override
    public void notifyChanged(Set<IResource> resources) {
        this.setChanged();
        this.notifyObservers(resources);
    }

    /* synthetic */ MercurialStatusCache(MercurialStatusCache mercurialStatusCache) {
        this();
    }

    private final class MemberStatusVisitor
    implements IResourceVisitor {
        private BitSet bitSet;
        private IResource parent;

        public MemberStatusVisitor(IResource parent, BitSet bitSet) {
            this.bitSet = bitSet;
            this.parent = parent;
        }

        public boolean visit(IResource resource) throws CoreException {
            BitSet memberBitSet;
            if (this.parent.isTeamPrivateMember()) {
                resource.setTeamPrivateMember(true);
                return false;
            }
            if (this.parent.isDerived()) {
                resource.setDerived(true);
                return false;
            }
            if (!resource.equals((Object)this.parent) && (memberBitSet = (BitSet)MercurialStatusCache.this.statusMap.get(resource.getLocation())) != null) {
                this.bitSet.or(memberBitSet);
            }
            return true;
        }
    }

    private static final class MercurialStatusCacheHolder {
        public static final MercurialStatusCache instance = new MercurialStatusCache(null);

        private MercurialStatusCacheHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final Map<IProject, Set<IResource>> removed;
        private final Map<IProject, Set<IResource>> changed;
        private final Map<IProject, Set<IResource>> added;
        private boolean completeStatus;
        private boolean autoShare;

        private ResourceDeltaVisitor(Map<IProject, Set<IResource>> removed, Map<IProject, Set<IResource>> changed, Map<IProject, Set<IResource>> added) {
            this.removed = removed;
            this.changed = changed;
            this.added = added;
            this.completeStatus = Boolean.valueOf(HgClients.getPreference("hg.performance.getStatusForCompleteRepository", "false"));
            this.autoShare = Boolean.valueOf(HgClients.getPreference(MercurialPreferenceConstants.PREF_AUTO_SHARE_PROJECTS, "false"));
        }

        private IResource getResource(IResource res) {
            IResource myRes = res;
            if (this.completeStatus) {
                myRes = res.getProject();
            }
            return myRes;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (res.isAccessible() && res.getType() == 8) {
                return true;
            }
            if (delta.getFlags() == 16384 && res.isAccessible() && RepositoryProvider.getProvider((IProject)res.getProject()) == null) {
                HgRoot hgRoot;
                final IProject project = res.getProject();
                try {
                    hgRoot = MercurialTeamProvider.getHgRoot((IResource)project);
                    MercurialEclipsePlugin.logInfo("Autosharing " + project.getName() + ". Detected repository location: " + hgRoot.getAbsolutePath(), null);
                }
                catch (HgException e) {
                    hgRoot = null;
                    MercurialEclipsePlugin.logInfo("Autosharing: " + e.getLocalizedMessage(), (Throwable)((Object)e));
                }
                final HgRoot root = hgRoot;
                if (root != null && root.length() > 0L && this.autoShare) {
                    final IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    try {
                        new SafeWorkspaceJob(String.valueOf(Messages.getString("MercurialStatusCache.autoshare.1")) + project.getName() + Messages.getString("MercurialStatusCache.autoshare.2")){

                            protected IStatus runSafe(IProgressMonitor monitor) {
                                try {
                                    new InitOperation((IRunnableContext)activeWorkbenchWindow, project, root, root.getAbsolutePath()).run(monitor);
                                }
                                catch (Exception e) {
                                    MercurialEclipsePlugin.logError(e);
                                    throw new RuntimeException(e);
                                }
                                return super.runSafe(monitor);
                            }
                        }.schedule();
                    }
                    catch (Exception e) {
                        MercurialEclipsePlugin.logError(e);
                        throw new HgException(e.getLocalizedMessage(), e);
                    }
                }
            }
            if (res.isAccessible() && !Team.isIgnoredHint((IResource)res) && (res.getType() == 8 || RepositoryProvider.getProvider((IProject)res.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null)) {
                Set<IResource> changeSet;
                Set<IResource> removeSet;
                IResource resource = this.getResource(res);
                IProject project = resource.getProject();
                Set<IResource> addSet = this.added.get(project);
                if (addSet == null) {
                    addSet = new HashSet<IResource>();
                }
                if ((removeSet = this.removed.get(project)) == null) {
                    removeSet = new HashSet<IResource>();
                }
                if ((changeSet = this.changed.get(project)) == null) {
                    changeSet = new HashSet<IResource>();
                }
                if (!res.isTeamPrivateMember() && !res.isDerived() && res.getType() == 1) {
                    int flag = delta.getFlags() & MercurialStatusCache.this.INTERESTING_CHANGES;
                    switch (delta.getKind()) {
                        case 1: {
                            addSet.add(resource);
                            this.added.put(project, addSet);
                            break;
                        }
                        case 4: {
                            if (!MercurialStatusCache.this.isSupervised(res) || flag == 0) break;
                            changeSet.add(resource);
                            this.changed.put(project, changeSet);
                            break;
                        }
                        case 2: {
                            if (!MercurialStatusCache.this.isSupervised(res)) break;
                            removeSet.add(this.getResource(res));
                            this.removed.put(project, removeSet);
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

