/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.history.MercurialHistoryProvider;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.HgMoveDeleteHook;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;

public class MercurialTeamProvider
extends RepositoryProvider {
    public static final String ID = "com.vectrace.MercurialEclipse.team.MercurialTeamProvider";
    public static final QualifiedName QUALIFIED_NAME_PROJECT_SOURCE_REPOSITORY = new QualifiedName("com.vectrace.MercurialEclipse.team.MercurialTeamProvider.projectSourceRepository", "MercurialEclipseProjectSourceRepository");
    public static final QualifiedName QUALIFIED_NAME_DEFAULT_REVISION_LIMIT = new QualifiedName("com.vectrace.MercurialEclipse.team.MercurialTeamProvider.defaultRevisionLimit", "defaultRevisionLimit");
    private static final Map<IProject, Boolean> HG_ROOTS = new HashMap<IProject, Boolean>();
    private MercurialHistoryProvider FileHistoryProvider = null;

    public void configureProject() throws CoreException {
        this.getProject().refreshLocal(2, null);
        MercurialTeamProvider.getHgRoot((IResource)this.getProject());
        IResource hgDir = this.getProject().findMember(".hg");
        if (hgDir != null && hgDir.exists()) {
            hgDir.setTeamPrivateMember(true);
            hgDir.setDerived(true);
        }
    }

    private static HgRoot getAndStoreHgRoot(IResource resource) throws HgException {
        HgRoot hgRoot;
        assert (resource != null);
        IProject project = resource.getProject();
        assert (project != null);
        try {
            hgRoot = (HgRoot)project.getSessionProperty(ResourceProperties.HG_ROOT);
            if (hgRoot == null) {
                String rootPath = HgRootClient.getHgRoot(resource);
                if (rootPath == null || rootPath.length() == 0) {
                    throw new HgException("There is no hg repository here (.hg not found)!");
                }
                hgRoot = new HgRoot(new File(rootPath));
                MercurialTeamProvider.setRepositoryEncoding(project, hgRoot);
                project.setSessionProperty(ResourceProperties.HG_ROOT, (Object)hgRoot);
            }
            HG_ROOTS.put(project, false);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
        return hgRoot;
    }

    private static void setRepositoryEncoding(IProject project, HgRoot hgRoot) throws CoreException {
        String encoding = null;
        if (project != null && (encoding = project.getDefaultCharset()) != null) {
            hgRoot.setEncoding(Charset.forName(encoding));
        }
    }

    private static HgRoot getHgRootFile(File file) throws HgException {
        assert (file != null);
        try {
            File rootFile = HgRootClient.getHgRoot(file);
            HgRoot root = new HgRoot(rootFile);
            return root;
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    private static HgRoot getAndStoreHgRoot(File file) throws CoreException {
        assert (file != null);
        IResource resource = MercurialUtilities.convert(file);
        if (resource != null) {
            return MercurialTeamProvider.getAndStoreHgRoot(resource);
        }
        return MercurialTeamProvider.getHgRootFile(file);
    }

    public static File getHgRootConfig(IResource resource) throws HgException {
        assert (resource != null);
        HgRoot hgRoot = MercurialTeamProvider.getHgRoot(resource);
        return hgRoot.getConfig();
    }

    public static HgRoot getHgRoot(IResource resource) throws HgException {
        assert (resource != null);
        try {
            return MercurialTeamProvider.getAndStoreHgRoot(resource);
        }
        catch (CoreException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public static HgRoot getHgRoot(File file) throws CoreException {
        assert (file != null);
        return MercurialTeamProvider.getAndStoreHgRoot(file);
    }

    public void deconfigure() throws CoreException {
        IProject project = this.getProject();
        assert (project != null);
        HG_ROOTS.remove(project);
        project.setPersistentProperty(ResourceProperties.HG_ROOT, null);
        project.setPersistentProperty(ResourceProperties.MERGING, null);
        project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
    }

    public String getID() {
        return ID;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return new HgMoveDeleteHook();
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        if (this.FileHistoryProvider == null) {
            this.FileHistoryProvider = new MercurialHistoryProvider();
        }
        return this.FileHistoryProvider;
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public boolean canHandleLinkedResourceURI() {
        return this.canHandleLinkedResources();
    }
}

