/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgIdentClient;
import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.synchronize.MercurialResourceVariant;
import com.vectrace.MercurialEclipse.synchronize.MercurialResourceVariantComparator;
import com.vectrace.MercurialEclipse.synchronize.MercurialSyncInfo;
import com.vectrace.MercurialEclipse.synchronize.Messages;
import com.vectrace.MercurialEclipse.team.IStorageMercurialRevision;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.OutgoingChangesetCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public class MercurialSynchronizeSubscriber
extends Subscriber {
    private static final IncomingChangesetCache INCOMING_CACHE = IncomingChangesetCache.getInstance();
    private static final OutgoingChangesetCache OUTGOING_CACHE = OutgoingChangesetCache.getInstance();
    private static final MercurialStatusCache STATUS_CACHE = MercurialStatusCache.getInstance();
    private ISynchronizationScope myScope;
    private IResource[] myRoots;
    private HgRepositoryLocation repositoryLocation;
    private IResourceVariantComparator comparator;

    public MercurialSynchronizeSubscriber(ISynchronizationScope synchronizationScope, HgRepositoryLocation repositoryLocation) {
        this.myScope = synchronizationScope;
        this.repositoryLocation = repositoryLocation;
    }

    public String getName() {
        return Messages.getString("MercurialSynchronizeSubscriber.repoWatcher");
    }

    public IResourceVariantComparator getResourceComparator() {
        if (this.comparator == null) {
            this.comparator = new MercurialResourceVariantComparator();
        }
        return this.comparator;
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        try {
            if (resource != null && RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && resource.getProject().isAccessible() && (this.isSupervised(resource) || !resource.exists())) {
                MercurialResourceVariant outgoing;
                IStorageMercurialRevision outgoingIStorage;
                ChangeSet csOutgoing = OUTGOING_CACHE.getNewestOutgoingChangeSet(resource, this.repositoryLocation);
                ChangeSet csIncoming = INCOMING_CACHE.getNewestIncomingChangeSet(resource, this.repositoryLocation);
                if (csOutgoing != null) {
                    outgoingIStorage = new IStorageMercurialRevision(resource, String.valueOf(csOutgoing.getRevision().getRevision()), csOutgoing.getChangeset(), csOutgoing);
                    outgoing = new MercurialResourceVariant(outgoingIStorage);
                } else if (resource.exists() && !STATUS_CACHE.isAdded((IResource)resource.getProject(), resource.getLocation())) {
                    File root = new File(HgRootClient.getHgRoot(resource));
                    String nodeId = HgIdentClient.getCurrentChangesetId(root);
                    csOutgoing = LocalChangesetCache.getInstance().getChangeSet(nodeId);
                    if (csOutgoing == null) {
                        csOutgoing = LocalChangesetCache.getInstance().getLocalChangeSet(resource, nodeId);
                    }
                    outgoingIStorage = new IStorageMercurialRevision(resource, String.valueOf(csOutgoing.getChangesetIndex()), csOutgoing.getChangeset(), csOutgoing);
                    outgoing = new MercurialResourceVariant(outgoingIStorage);
                } else {
                    outgoingIStorage = null;
                    outgoing = null;
                }
                IStorageMercurialRevision incomingIStorage = csIncoming != null ? this.getIncomingIStorage(resource, csIncoming) : outgoingIStorage;
                MercurialResourceVariant incoming = incomingIStorage != null ? new MercurialResourceVariant(incomingIStorage) : null;
                MercurialSyncInfo info = new MercurialSyncInfo(resource, outgoing, incoming, this.getResourceComparator());
                info.init();
                return info;
            }
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
        return null;
    }

    private IStorageMercurialRevision getIncomingIStorage(IResource resource, ChangeSet csRemote) {
        IStorageMercurialRevision incomingIStorage = new IStorageMercurialRevision(resource, String.valueOf(csRemote.getRevision().getRevision()), csRemote.getChangeset(), csRemote);
        return incomingIStorage;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return STATUS_CACHE.isSupervised(resource) && resource.getType() == 1;
    }

    public IResource[] members(IResource resource) throws TeamException {
        HashSet<IResource> members = new HashSet<IResource>();
        IResource[] localMembers = STATUS_CACHE.getLocalMembers(resource);
        IResource[] outgoingMembers = OUTGOING_CACHE.getOutgoingMembers(resource, this.repositoryLocation);
        IResource[] incomingMembers = INCOMING_CACHE.getIncomingMembers(resource, this.repositoryLocation);
        if (localMembers != null && localMembers.length > 0) {
            members.addAll(Arrays.asList(localMembers));
        }
        if (outgoingMembers != null && outgoingMembers.length > 0) {
            members.addAll(Arrays.asList(outgoingMembers));
        }
        if (incomingMembers != null && incomingMembers.length > 0) {
            members.addAll(Arrays.asList(incomingMembers));
        }
        members.remove(resource.getProject());
        members.remove(resource);
        return members.toArray(new IResource[members.size()]);
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[] toRefresh = resources;
        if (toRefresh == null) {
            toRefresh = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        HashSet<IProject> refreshed = new HashSet<IProject>(toRefresh.length);
        monitor.beginTask(String.valueOf(Messages.getString("MercurialSynchronizeSubscriber.refreshing")) + this.getName() + Messages.getString("MercurialSynchronizeSubscriber.refreshing.2") + this.repositoryLocation + "...", 10);
        monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingResources"));
        ArrayList<SubscriberChangeEvent> changeEvents = new ArrayList<SubscriberChangeEvent>();
        IResource[] iResourceArray = toRefresh;
        int n = toRefresh.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            IProject project = resource.getProject();
            if (refreshed.contains(project)) {
                monitor.worked(1);
            } else {
                AbstractCache.clearNodeMap();
                monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingIncoming"));
                IResource[] incomingMembers = null;
                IResource[] outgoingMembers = null;
                if (this.repositoryLocation != null) {
                    INCOMING_CACHE.clear(this.repositoryLocation);
                    INCOMING_CACHE.refreshIncomingChangeSets(project, this.repositoryLocation);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingOutgoing"));
                    OUTGOING_CACHE.clear(this.repositoryLocation);
                    OUTGOING_CACHE.refreshOutgoingChangeSets(project, this.repositoryLocation);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    incomingMembers = INCOMING_CACHE.getIncomingMembers(resource, this.repositoryLocation);
                    outgoingMembers = OUTGOING_CACHE.getOutgoingMembers(resource, this.repositoryLocation);
                }
                monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingLocal"));
                MercurialStatusCache.getInstance().refreshStatus((IResource)project, monitor);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return;
                }
                refreshed.add(project);
                IResource[] localMembers = STATUS_CACHE.getLocalMembers(resource);
                HashSet<IResource> resourcesToRefresh = new HashSet<IResource>();
                if (localMembers != null) {
                    resourcesToRefresh.addAll(Arrays.asList(localMembers));
                }
                if (incomingMembers != null) {
                    resourcesToRefresh.addAll(Arrays.asList(incomingMembers));
                }
                if (outgoingMembers != null) {
                    resourcesToRefresh.addAll(Arrays.asList(outgoingMembers));
                }
                for (IResource res : resourcesToRefresh) {
                    changeEvents.add(new SubscriberChangeEvent((Subscriber)this, 1, res));
                }
                monitor.worked(1);
            }
            ++n2;
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.getString("MercurialSynchronizeSubscriber.triggeringStatusCalc"));
        super.fireTeamResourceChange(changeEvents.toArray(new ISubscriberChangeEvent[changeEvents.size()]));
        monitor.worked(1);
        monitor.done();
    }

    public IResource[] roots() {
        if (this.myRoots == null) {
            this.myRoots = this.myScope != null && this.myScope.getRoots() != null ? this.myScope.getRoots() : ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        return this.myRoots;
    }

    public static Subscriber getInstance() {
        MercurialSynchronizeSubscriber sub = new MercurialSynchronizeSubscriber();
        return sub;
    }

    private MercurialSynchronizeSubscriber() {
    }
}

