/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.utils.IniFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;

public class HgRoot
extends File {
    private static final long serialVersionUID = 2L;
    private Charset encoding;
    private Charset fallbackencoding;
    private File config;

    public HgRoot(String pathname) {
        super(pathname);
        this.init();
    }

    public HgRoot(File file) throws IOException {
        this(file.getCanonicalPath());
    }

    public HgRoot(URI uri) {
        super(uri);
        this.init();
    }

    public HgRoot(String parent, String child) {
        super(parent, child);
        this.init();
    }

    public HgRoot(File parent, String child) {
        super(parent, child);
        this.init();
    }

    private void init() {
        String enc = System.getProperty("HGENCODING");
        if (enc == null || enc.length() == 0) {
            enc = Charset.defaultCharset().name();
        }
        this.setEncoding(Charset.forName(enc));
        String fallback = this.getConfigItem("ui", "fallbackencoding");
        if (this.fallbackencoding == null) {
            if (fallback == null || fallback.length() == 0) {
                fallback = "windows-1251";
            }
            this.fallbackencoding = Charset.forName(fallback);
        }
    }

    public void setEncoding(Charset charset) {
        this.encoding = charset;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public File getConfig() {
        File hgrc;
        if (this.config == null && (hgrc = new File(this, ".hg/hgrc")).exists()) {
            this.config = hgrc;
            return hgrc;
        }
        return null;
    }

    public String getConfigItem(String section, String key) {
        this.getConfig();
        if (this.config != null) {
            try {
                IniFile iniFile = new IniFile(this.config.getAbsolutePath());
                return iniFile.getKeyValue(section, key);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    public Charset getFallbackencoding() {
        return this.fallbackencoding;
    }
}

