/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.HgRevision;
import com.vectrace.MercurialEclipse.model.FileStatus;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.compare.patch.IFilePatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet
implements Comparable<ChangeSet> {
    private int changesetIndex;
    private String changeset;
    private String tag;
    private String branch;
    private String user;
    private String date;
    private FileStatus[] changedFiles;
    private String description;
    private String ageDate;
    private String nodeShort;
    private String[] parents;
    private Date realDate;
    private File bundleFile;
    private HgRepositoryLocation repository;
    private Direction direction;
    private String summary;
    private File hgRoot;
    private IFilePatch[] patches;

    private ChangeSet(int changesetIndex, String changeSet, String tag, String branch, String user, String date, String description, String[] parents) {
        this.changesetIndex = changesetIndex;
        this.changeset = changeSet;
        this.tag = tag;
        this.branch = branch;
        this.user = user;
        this.date = date;
        this.setDescription(description);
        this.setParents(parents);
        try {
            if (date != null) {
                this.realDate = new SimpleDateFormat("yyyy-MM-dd hh:mm Z").parse(date);
            }
        }
        catch (Exception exception) {
            this.realDate = null;
        }
    }

    private ChangeSet(int changesetIndex, String changeSet, String user, String date, String branch) {
        this(changesetIndex, changeSet, null, branch, user, date, "", null);
    }

    public int getChangesetIndex() {
        return this.changesetIndex;
    }

    public String getChangeset() {
        return this.changeset;
    }

    public String getTag() {
        if (this.tag != null && this.tag.equals("tip") && this.bundleFile != null) {
            this.tag = this.tag.concat(" [ ").concat(this.repository.toString()).concat(" ]");
        }
        return this.tag;
    }

    public String getBranch() {
        if (this.branch == null) {
            return "";
        }
        return this.branch;
    }

    public String getUser() {
        return this.user;
    }

    public String getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public HgRevision getRevision() {
        return new HgRevision(this.changeset, this.changesetIndex);
    }

    public String toString() {
        if (this.nodeShort != null) {
            return String.valueOf(this.changesetIndex) + ":" + this.nodeShort;
        }
        return String.valueOf(this.changesetIndex) + ":" + this.changeset;
    }

    public FileStatus[] getChangedFiles() {
        if (this.changedFiles != null) {
            return (FileStatus[])this.changedFiles.clone();
        }
        return new FileStatus[0];
    }

    public String getAgeDate() {
        return this.ageDate;
    }

    public String getNodeShort() {
        return this.nodeShort;
    }

    @Override
    public int compareTo(ChangeSet o) {
        int dateCompare;
        if (o.getChangeset().equals(this.getChangeset())) {
            return 0;
        }
        if (this.realDate != null && o.getRealDate() != null && (dateCompare = this.getRealDate().compareTo(o.getRealDate())) != 0) {
            return dateCompare;
        }
        return this.getChangesetIndex() - o.getChangesetIndex();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ChangeSet) {
            return this.compareTo((ChangeSet)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changeset == null ? 0 : this.changeset.hashCode());
        return result;
    }

    public Date getRealDate() {
        return this.realDate;
    }

    public File getBundleFile() {
        return this.bundleFile;
    }

    public String[] getParents() {
        return this.parents;
    }

    private void setParents(String[] parents) {
        if (parents != null) {
            ArrayList<String> temp = new ArrayList<String>(parents.length);
            int i = 0;
            while (i < parents.length) {
                String parent = parents[i];
                if (parent.charAt(0) != '-') {
                    temp.add(parent);
                }
                ++i;
            }
            this.parents = temp.toArray(new String[temp.size()]);
        }
    }

    private void setDescription(String description) {
        if (description != null) {
            int i = description.indexOf(10);
            this.summary = i > 0 ? description.substring(0, i >= 0 ? i : description.length()) : description;
            this.description = description;
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public HgRepositoryLocation getRepository() {
        return this.repository;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public File getHgRoot() {
        return this.hgRoot;
    }

    public IFilePatch[] getPatches() {
        return this.patches;
    }

    /* synthetic */ ChangeSet(int n, String string, String string2, String string3, String string4, ChangeSet changeSet) {
        this(n, string, string2, string3, string4);
    }

    public static class Builder {
        private ChangeSet cs;

        public Builder(int revision, String changeSet, String branch, String date, String user) {
            this.cs = new ChangeSet(revision, changeSet, user, date, branch, null);
        }

        public Builder tag(String tag) {
            this.cs.tag = tag;
            return this;
        }

        public Builder description(String description) {
            this.cs.setDescription(description);
            return this;
        }

        public Builder parents(String[] parents) {
            this.cs.setParents(parents);
            return this;
        }

        public Builder direction(Direction direction) {
            this.cs.direction = direction;
            return this;
        }

        public Builder changedFiles(FileStatus[] changedFiles) {
            this.cs.changedFiles = changedFiles;
            return this;
        }

        public Builder bundleFile(File bundleFile) {
            this.cs.bundleFile = bundleFile;
            return this;
        }

        public Builder repository(HgRepositoryLocation repository) {
            this.cs.repository = repository;
            return this;
        }

        public Builder hgRoot(File hgRoot) {
            this.cs.hgRoot = hgRoot;
            return this;
        }

        public Builder ageDate(String ageDate) {
            this.cs.ageDate = ageDate;
            return this;
        }

        public Builder nodeShort(String nodeShort) {
            this.cs.nodeShort = nodeShort;
            return this;
        }

        public void patches(IFilePatch[] patches) {
            this.cs.patches = patches;
        }

        public ChangeSet build() {
            ChangeSet result = this.cs;
            this.cs = null;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        INCOMING,
        OUTGOING,
        LOCAL;

    }
}

