/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.history;

import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgGLogClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgSigsClient;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.GChangeSet;
import com.vectrace.MercurialEclipse.model.Signature;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;

public class MercurialHistory
extends FileHistory {
    private static ChangeSetComparator csComparator = null;
    private static RevisionComparator revComparator = null;
    private IResource resource;
    protected SortedSet<MercurialRevision> revisions;
    Map<Integer, GChangeSet> gChangeSets;
    private int bottom = 0;

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public MercurialHistory(IResource resource) {
        this.resource = resource;
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        return null;
    }

    public IFileRevision getFileRevision(String id) {
        if (this.revisions == null || this.revisions.size() == 0) {
            return null;
        }
        for (MercurialRevision rev : this.revisions) {
            if (!rev.getContentIdentifier().equals(id)) continue;
            return rev;
        }
        return null;
    }

    public IFileRevision[] getFileRevisions() {
        if (this.revisions != null) {
            return (IFileRevision[])this.revisions.toArray(new MercurialRevision[this.revisions.size()]);
        }
        return new IFileRevision[0];
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        return new IFileRevision[0];
    }

    public void refresh(IProgressMonitor monitor, int from) throws CoreException {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.resource.getProject());
        if (provider != null && provider instanceof MercurialTeamProvider) {
            TreeSet<ChangeSet> changeSets = new TreeSet<ChangeSet>(this.getChangeSetComparator());
            int logBatchSize = Integer.parseInt(MercurialUtilities.getPreference("hg.batchsize.log", "500"));
            if (from == this.bottom || from < 0) {
                return;
            }
            Map<IPath, SortedSet<ChangeSet>> map = HgLogClient.getProjectLog(this.resource, logBatchSize, from, false);
            if (map == null) {
                this.bottom = from;
                return;
            }
            SortedSet<ChangeSet> localChangeSets = map.get(this.resource.getLocation());
            if (localChangeSets != null) {
                File file = this.resource.getLocation().toFile();
                List<Signature> sigs = HgSigsClient.getSigs(file);
                HashMap<String, Signature> sigMap = new HashMap<String, Signature>();
                if (!MercurialUtilities.getGpgExecutable().equals("false")) {
                    for (Signature signature : sigs) {
                        sigMap.put(signature.getNodeId(), signature);
                    }
                }
                changeSets.addAll(localChangeSets);
                if (this.revisions == null || this.revisions.size() == 0 || this.revisions.size() < changeSets.size() || !this.revisions.first().getResource().equals((Object)this.resource)) {
                    this.revisions = new TreeSet<MercurialRevision>(this.getRevisionComparator());
                    List<GChangeSet> gLogChangeSets = new HgGLogClient(this.resource).update(changeSets).getChangeSets();
                    this.gChangeSets = new HashMap<Integer, GChangeSet>(gLogChangeSets.size());
                    for (GChangeSet gs : gLogChangeSets) {
                        if (gs == null) continue;
                        this.gChangeSets.put(gs.getRev(), gs);
                    }
                }
                for (ChangeSet cs : changeSets) {
                    Signature sig = (Signature)sigMap.get(cs.getChangeset());
                    this.revisions.add(new MercurialRevision(cs, this.gChangeSets.get(cs.getChangesetIndex()), this.resource, sig));
                }
            }
        }
    }

    private ChangeSetComparator getChangeSetComparator() {
        if (csComparator == null) {
            csComparator = new ChangeSetComparator();
        }
        return csComparator;
    }

    private RevisionComparator getRevisionComparator() {
        if (revComparator == null) {
            revComparator = new RevisionComparator();
        }
        return revComparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangeSetComparator
    implements Comparator<ChangeSet>,
    Serializable {
        private static final long serialVersionUID = 6661721027440425773L;

        private ChangeSetComparator() {
        }

        @Override
        public int compare(ChangeSet o1, ChangeSet o2) {
            int dateCompare;
            int result = o2.getChangesetIndex() - o1.getChangesetIndex();
            if (result == 0 && o1.getRealDate() != null && o2.getRealDate() != null && (dateCompare = o2.getRealDate().compareTo(o1.getRealDate())) != 0) {
                result = dateCompare;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RevisionComparator
    implements Comparator<MercurialRevision>,
    Serializable {
        private static final long serialVersionUID = 5305190339206751711L;

        private RevisionComparator() {
        }

        @Override
        public int compare(MercurialRevision o1, MercurialRevision o2) {
            int dateCompare;
            int result = o2.getChangeSet().getChangesetIndex() - o1.getChangeSet().getChangesetIndex();
            if (result == 0 && o1.getChangeSet().getRealDate() != null && o2.getChangeSet().getRealDate() != null && (dateCompare = o2.getChangeSet().getRealDate().compareTo(o1.getChangeSet().getRealDate())) != 0) {
                result = dateCompare;
            }
            return result;
        }
    }
}

