/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.history;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.history.ChangePathsTableProvider;
import com.vectrace.MercurialEclipse.history.MercurialHistoryPage;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.history.TextViewerAction;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class ChangedPathsPage {
    private final String PREF_SHOW_COMMENTS = "pref_show_comments";
    private final String PREF_WRAP_COMMENTS = "pref_wrap_comments";
    private final String PREF_SHOW_PATHS = "pref_show_paths";
    private final String PREF_AFFECTED_PATHS_LAYOUT = "pref_affected_paths_layout2";
    private final String IMG_COMMENTS = "comments.gif";
    private final String IMG_AFFECTED_PATHS_FLAT_MODE = "flatLayout.gif";
    private final int LAYOUT_HORIZONTAL = 1;
    private final int LAYOUT_VERTICAL = 2;
    private SashForm mainSashForm;
    private SashForm innerSashForm;
    private boolean showComments;
    private boolean showAffectedPaths;
    private boolean wrapCommentsText;
    private StructuredViewer changePathsViewer;
    private TextViewer textViewer;
    private IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
    private ToggleAffectedPathsOptionAction[] toggleAffectedPathsLayoutActions;
    private final MercurialHistoryPage page;

    public ChangedPathsPage(MercurialHistoryPage page, Composite parent) {
        this.page = page;
        this.init(parent);
    }

    private void init(Composite parent) {
        this.showComments = this.store.getBoolean("pref_show_comments");
        this.wrapCommentsText = this.store.getBoolean("pref_wrap_comments");
        this.showAffectedPaths = this.store.getBoolean("pref_show_paths");
        this.mainSashForm = new SashForm(parent, 512);
        this.mainSashForm.setLayoutData((Object)new GridData(1808));
        this.toggleAffectedPathsLayoutActions = new ToggleAffectedPathsOptionAction[]{new ToggleAffectedPathsOptionAction(this, "HistoryView.affectedPathsHorizontalLayout", "pref_affected_paths_layout2", 1), new ToggleAffectedPathsOptionAction(this, "HistoryView.affectedPathsVerticalLayout", "pref_affected_paths_layout2", 2)};
    }

    public void createControl() {
        this.createAffectedPathsViewer();
        this.addSelectionListener();
        this.contributeActions();
    }

    private void addSelectionListener() {
        this.page.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){
            private Object currentLogEntry;

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection _selection = event.getSelection();
                Object logEntry = ((IStructuredSelection)_selection).getFirstElement();
                if (logEntry != this.currentLogEntry) {
                    this.currentLogEntry = logEntry;
                    ChangedPathsPage.this.updatePanels(_selection);
                }
            }
        });
    }

    private void createAffectedPathsViewer() {
        int layout;
        int[] weights = null;
        weights = this.mainSashForm.getWeights();
        if (this.innerSashForm != null) {
            this.innerSashForm.dispose();
        }
        if (this.changePathsViewer != null) {
            this.changePathsViewer.getControl().dispose();
        }
        if ((layout = this.store.getInt("pref_affected_paths_layout2")) == 1) {
            this.innerSashForm = new SashForm((Composite)this.mainSashForm, 256);
        } else {
            this.innerSashForm = new SashForm((Composite)this.mainSashForm, 512);
            this.createText((Composite)this.innerSashForm);
        }
        this.changePathsViewer = new ChangePathsTableProvider((Composite)this.innerSashForm, this);
        if (layout == 1) {
            this.createText((Composite)this.innerSashForm);
        }
        this.setViewerVisibility();
        this.innerSashForm.layout();
        if (weights != null && weights.length == 2) {
            this.mainSashForm.setWeights(weights);
        }
        this.mainSashForm.layout();
        this.updatePanels(this.page.getTableViewer().getSelection());
    }

    private void updatePanels(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            this.textViewer.setDocument((IDocument)new Document(""));
            this.changePathsViewer.setInput(null);
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            this.textViewer.setDocument((IDocument)new Document(""));
            this.changePathsViewer.setInput(null);
            return;
        }
        MercurialRevision entry = (MercurialRevision)((Object)ss.getFirstElement());
        this.textViewer.setDocument((IDocument)new Document(entry.getChangeSet().getDescription()));
        this.changePathsViewer.setInput((Object)entry);
    }

    private void createText(Composite parent) {
        SourceViewer result = new SourceViewer(parent, null, null, true, 778);
        result.getTextWidget().setIndent(2);
        this.textViewer = result;
        final TextViewerAction copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
        copyAction.setText(Messages.getString("HistoryView.copy"));
        this.textViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                copyAction.update();
            }
        });
        final TextViewerAction selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
        selectAllAction.setText(Messages.getString("HistoryView.selectAll"));
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        IPageSite pageSite = parentSite.getWorkbenchPageSite();
        IActionBars actionBars = pageSite.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)copyAction);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)selectAllAction);
        actionBars.updateActionBars();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr1) {
                menuMgr1.add((IAction)copyAction);
                menuMgr1.add((IAction)selectAllAction);
            }
        });
        StyledText text = this.textViewer.getTextWidget();
        Menu menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void contributeActions() {
        Action toggleShowComments = new Action(Messages.getString("HistoryView.showComments"), MercurialEclipsePlugin.getImageDescriptor("comments.gif")){

            public void run() {
                ChangedPathsPage.this.showComments = this.isChecked();
                ChangedPathsPage.this.setViewerVisibility();
                ChangedPathsPage.this.store.setValue("pref_show_comments", ChangedPathsPage.this.showComments);
            }
        };
        toggleShowComments.setChecked(this.showComments);
        Action toggleWrapCommentsAction = new Action(Messages.getString("HistoryView.wrapComments")){

            public void run() {
                ChangedPathsPage.this.wrapCommentsText = this.isChecked();
                ChangedPathsPage.this.setViewerVisibility();
                ChangedPathsPage.this.store.setValue("pref_wrap_comments", ChangedPathsPage.this.wrapCommentsText);
            }
        };
        toggleWrapCommentsAction.setChecked(this.wrapCommentsText);
        Action toggleShowAffectedPathsAction = new Action(Messages.getString("HistoryView.showAffectedPaths"), MercurialEclipsePlugin.getImageDescriptor("flatLayout.gif")){

            public void run() {
                ChangedPathsPage.this.showAffectedPaths = this.isChecked();
                ChangedPathsPage.this.setViewerVisibility();
                ChangedPathsPage.this.store.setValue("pref_show_paths", ChangedPathsPage.this.showAffectedPaths);
            }
        };
        toggleShowAffectedPathsAction.setChecked(this.showAffectedPaths);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        IPageSite pageSite = parentSite.getWorkbenchPageSite();
        IActionBars actionBars = pageSite.getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        actionBarsMenu.add((IAction)toggleWrapCommentsAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)toggleShowComments);
        actionBarsMenu.add((IAction)toggleShowAffectedPathsAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        int i = 0;
        while (i < this.toggleAffectedPathsLayoutActions.length) {
            actionBarsMenu.add((IAction)this.toggleAffectedPathsLayoutActions[i]);
            ++i;
        }
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)toggleShowComments);
        tbm.add((IAction)toggleShowAffectedPathsAction);
        tbm.update(false);
        actionBars.updateActionBars();
    }

    private void setViewerVisibility() {
        if (this.showComments && this.showAffectedPaths) {
            this.mainSashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
        } else if (this.showComments) {
            this.mainSashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (this.showAffectedPaths) {
            this.mainSashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(this.changePathsViewer.getControl());
        } else {
            this.mainSashForm.setMaximizedControl((Control)this.page.getTableViewer().getControl().getParent());
        }
        this.changePathsViewer.refresh();
        this.textViewer.getTextWidget().setWordWrap(this.wrapCommentsText);
    }

    private IHistoryPageSite getHistoryPageSite() {
        return this.page.getHistoryPageSite();
    }

    public Composite getControl() {
        return this.mainSashForm;
    }

    public boolean isShowChangePaths() {
        return this.showAffectedPaths;
    }

    public static class ToggleAffectedPathsOptionAction
    extends Action {
        private final ChangedPathsPage page;
        private final String preferenceName;
        private final int value;

        public ToggleAffectedPathsOptionAction(ChangedPathsPage page, String label, String preferenceName, int value) {
            super(Messages.getString(label), 8);
            this.page = page;
            this.preferenceName = preferenceName;
            this.value = value;
            IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
            this.setChecked(value == store.getInt(preferenceName));
        }

        public void run() {
            if (this.isChecked()) {
                MercurialEclipsePlugin.getDefault().getPreferenceStore().setValue(this.preferenceName, this.value);
                this.page.createAffectedPathsViewer();
            }
        }
    }
}

