/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.HgAddClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgCommitClient;
import com.vectrace.MercurialEclipse.commands.HgRemoveClient;
import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.menu.CommitMergeHandler;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.ActionRevert;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import com.vectrace.MercurialEclipse.ui.CommitFilesChooser;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDialog
extends TitleAreaDialog {
    public static final String FILE_MODIFIED = Messages.getString("CommitDialog.modified");
    public static final String FILE_ADDED = Messages.getString("CommitDialog.added");
    public static final String FILE_REMOVED = Messages.getString("CommitDialog.removed");
    public static final String FILE_UNTRACKED = Messages.getString("CommitDialog.untracked");
    public static final String FILE_DELETED = Messages.getString("CommitDialog.deletedInWorkspace");
    private String defaultCommitMessage = Messages.getString("CommitDialog.defaultCommitMessage");
    private Combo oldCommitComboBox;
    private ISourceViewer commitTextBox;
    private CommitFilesChooser commitFilesList;
    private boolean selectableFiles;
    private HgRoot root;
    private List<IResource> resourcesToAdd;
    private List<IResource> resourcesToCommit;
    private List<IResource> resourcesToRemove;
    private String commitMessage;
    private IDocument commitTextDocument;
    private SourceViewerDecorationSupport decorationSupport;
    private List<IResource> inResources;
    private Text userTextField;
    private String user;
    private Button revertCheckBox;
    private ActiveChangeSetManager csManager = MercurialEclipsePlugin.getDefault().getChangeSetManager();

    public CommitDialog(Shell shell, HgRoot root, List<IResource> resources) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x20);
        this.setBlockOnOpen(false);
        this.root = root;
        this.inResources = resources;
        this.selectableFiles = true;
        this.commitTextDocument = new Document();
    }

    public CommitDialog(Shell shell, HgRoot root, ArrayList<IResource> selectedResource, String defaultCommitMessage, boolean selectableFiles) {
        this(shell, root, selectedResource);
        this.selectableFiles = selectableFiles;
        this.defaultCommitMessage = defaultCommitMessage;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public List<IResource> getResourcesToCommit() {
        return this.resourcesToCommit;
    }

    public List<IResource> getResourcesToAdd() {
        return this.resourcesToAdd;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = SWTWidgetHelper.createComposite(parent, 1);
        GridData gd = SWTWidgetHelper.getFillGD(400);
        gd.minimumWidth = 500;
        container.setLayoutData((Object)gd);
        super.createDialogArea(parent);
        container.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' && e.stateMask == SWT.MOD1) {
                    CommitDialog.this.okPressed();
                    e.doit = false;
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.createCommitTextBox(container);
        this.createOldCommitCombo(container);
        this.createUserCommitCombo(container);
        this.createFilesList(container);
        this.createRevertCheckBox(container);
        this.setupDefaultCommitMessage();
        this.commitTextBox.getTextWidget().setFocus();
        this.setTitle(Messages.getString("CommitDialog.title"));
        this.setMessage(Messages.getString("CommitDialog.message"));
        return container;
    }

    private void createRevertCheckBox(Composite container) {
        this.revertCheckBox = SWTWidgetHelper.createCheckBox(container, Messages.getString("CommitDialog.revertCheckBoxLabel.revertUncheckedResources"));
    }

    private void createFilesList(Composite container) {
        SWTWidgetHelper.createLabel(container, Messages.getString("CommitDialog.selectFiles"));
        this.commitFilesList = new CommitFilesChooser(container, this.selectableFiles, this.inResources, this.root, true);
    }

    private void createUserCommitCombo(Composite container) {
        Composite comp = SWTWidgetHelper.createComposite(container, 2);
        SWTWidgetHelper.createLabel(comp, Messages.getString("CommitDialog.userLabel.text"));
        this.userTextField = SWTWidgetHelper.createTextField(comp);
        if (this.user == null || this.user.length() == 0) {
            this.user = HgClients.getDefaultUserName();
        }
        this.userTextField.setText(this.user);
    }

    private void createCommitTextBox(Composite container) {
        this.setMessage(Messages.getString("CommitDialog.commitTextLabel.text"));
        this.commitTextBox = new SourceViewer(container, null, 2626);
        this.commitTextBox.setEditable(true);
        this.commitTextBox.getTextWidget().setLayoutData((Object)SWTWidgetHelper.getFillGD(150));
        this.decorationSupport = new SourceViewerDecorationSupport(this.commitTextBox, null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), EditorsUI.getSharedTextColors());
        AnnotationPreference pref = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.ui.workbench.texteditor.spelling");
        this.decorationSupport.setAnnotationPreference(pref);
        this.decorationSupport.install(EditorsUI.getPreferenceStore());
        this.commitTextBox.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
        AnnotationModel annotationModel = new AnnotationModel();
        this.commitTextBox.setDocument(this.commitTextDocument, (IAnnotationModel)annotationModel);
        this.commitTextBox.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitDialog.this.decorationSupport.uninstall();
            }
        });
    }

    private void createOldCommitCombo(Composite container) {
        final String[] oldCommits = MercurialEclipsePlugin.getCommitMessageManager().getCommitMessages();
        if (oldCommits.length > 0) {
            this.oldCommitComboBox = SWTWidgetHelper.createCombo(container);
            this.oldCommitComboBox.add(Messages.getString("CommitDialog.oldCommitMessages"));
            this.oldCommitComboBox.setText(Messages.getString("CommitDialog.oldCommitMessages"));
            int i = 0;
            while (i < oldCommits.length) {
                this.oldCommitComboBox.add(oldCommits[i].replaceAll("\\n", "<br>"));
                ++i;
            }
            this.oldCommitComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CommitDialog.this.oldCommitComboBox.getSelectionIndex() != 0) {
                        CommitDialog.this.commitTextDocument.set(oldCommits[CommitDialog.this.oldCommitComboBox.getSelectionIndex() - 1]);
                        CommitDialog.this.commitTextBox.setSelectedRange(0, oldCommits[CommitDialog.this.oldCommitComboBox.getSelectionIndex() - 1].length());
                    }
                }
            });
        }
    }

    protected void okPressed() {
        try {
            this.resourcesToAdd = this.commitFilesList.getCheckedResources(FILE_UNTRACKED);
            this.resourcesToCommit = this.commitFilesList.getCheckedResources(new String[0]);
            this.resourcesToRemove = this.commitFilesList.getCheckedResources(FILE_DELETED);
            this.commitMessage = this.commitTextDocument.get();
            if (!this.commitMessage.equals(this.defaultCommitMessage)) {
                MercurialEclipsePlugin.getCommitMessageManager().saveCommitMessage(this.commitMessage);
            }
            this.user = this.userTextField.getText();
            HgAddClient.addResources(this.resourcesToAdd, null);
            HgRemoveClient.removeResources(this.resourcesToRemove);
            String messageToCommit = this.getCommitMessage();
            if (this.user == null || this.user.length() == 0) {
                this.user = HgClients.getDefaultUserName();
            }
            if (!this.selectableFiles) {
                CommitMergeHandler.commitMerge(this.inResources.get(0), messageToCommit);
            } else {
                HgCommitClient.commitResources(this.resourcesToCommit, this.user, messageToCommit, (IProgressMonitor)new NullProgressMonitor());
            }
            if (this.inResources.size() > 0) {
                new RefreshJob(Messages.getString("CommitDialog.refreshing"), null, this.inResources.get(0).getProject()).schedule();
            }
            if (this.revertCheckBox.getSelection()) {
                final List<IResource> revertResources = this.commitFilesList.getUncheckedResources(FILE_ADDED, FILE_DELETED, FILE_MODIFIED, FILE_REMOVED);
                new SafeWorkspaceJob(Messages.getString("CommitDialog.revertJob.RevertingFiles")){

                    protected IStatus runSafe(IProgressMonitor monitor) {
                        ActionRevert action = new ActionRevert();
                        action.doRevert(monitor, revertResources);
                        return super.runSafe(monitor);
                    }
                }.schedule();
            }
            super.okPressed();
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            this.setErrorMessage(e.getLocalizedMessage());
        }
    }

    protected void setRoot(HgRoot root) {
        this.root = root;
    }

    protected HgRoot getRoot() {
        return this.root;
    }

    public List<IResource> getResourcesToRemove() {
        return this.resourcesToRemove;
    }

    private void setupDefaultCommitMessage() {
        String msg = this.getProposedComment(this.inResources.toArray(new IResource[this.inResources.size()]));
        if (msg != null && msg.length() > 0) {
            this.commitTextDocument.set(msg);
        } else {
            this.commitTextDocument.set(this.defaultCommitMessage);
            this.commitTextBox.setSelectedRange(0, this.defaultCommitMessage.length());
        }
    }

    public String getUser() {
        return this.user;
    }

    private String getProposedComment(IResource[] resourcesToCommit) {
        StringBuffer comment = new StringBuffer();
        ChangeSet[] sets = this.csManager.getSets();
        int numMatchedSets = 0;
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (this.isUserSet(set) && this.containsOne(set, resourcesToCommit)) {
                if (numMatchedSets > 0) {
                    comment.append(System.getProperty("line.separator"));
                }
                comment.append(set.getComment());
                ++numMatchedSets;
            }
            ++i;
        }
        return comment.toString();
    }

    private boolean isUserSet(ChangeSet set) {
        if (set instanceof ActiveChangeSet) {
            ActiveChangeSet acs = (ActiveChangeSet)set;
            return acs.isUserCreated();
        }
        return false;
    }

    private boolean containsOne(ChangeSet set, IResource[] resourcesToCommit) {
        int j = 0;
        while (j < resourcesToCommit.length) {
            ActiveChangeSet acs;
            IResource resource = resourcesToCommit[j];
            if (set.contains(resource)) {
                return true;
            }
            if (set instanceof ActiveChangeSet && (acs = (ActiveChangeSet)set).getDiffTree().members(resource).length > 0) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

