/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.AbstractShellCommand;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class HgServeClient {
    public void serve(IResource hgRoot, int port, String prefixPath, String name, String webdirConf, boolean stdio, boolean ipv6) throws IOException {
        new HgServeJob(hgRoot, port, prefixPath, name, webdirConf, ipv6, stdio).schedule();
    }

    private static AbstractShellCommand getCommand(IResource hgRoot, int port, String prefixPath, String name, String webdirConf, boolean stdio, boolean ipv6) throws IOException {
        HgCommand command = new HgCommand("serve", new File(hgRoot.getLocation().toOSString()), true);
        File pidFile = File.createTempFile("hgserve_" + hgRoot.getName(), ".pidfile");
        pidFile.deleteOnExit();
        if (port != 8000) {
            command.addOptions("--port", String.valueOf(port));
        }
        if (prefixPath != null && prefixPath.length() > 0) {
            command.addOptions("--prefix", prefixPath);
        }
        if (name != null && name.length() > 0) {
            command.addOptions("--name", name);
        }
        if (webdirConf != null && webdirConf.length() > 0) {
            command.addOptions("--webdir-conf", webdirConf);
        }
        if (stdio) {
            command.addOptions("--stdio");
        }
        if (ipv6) {
            command.addOptions("--ipv6");
        }
        return command;
    }

    class HgServeJob
    extends SafeWorkspaceJob {
        private IResource hgRoot;
        private boolean ipv6;
        private String name;
        private String prefix;
        private int port;
        private String webdirConf;
        private boolean stdio;

        public HgServeJob(IResource hgRoot, int port, String prefix, String name, String webdirConf, boolean ipv6, boolean stdio) {
            super(String.valueOf(Messages.getString("HgServeClient.serveJob.name")) + hgRoot.getName() + "...");
            this.hgRoot = null;
            this.hgRoot = hgRoot;
            this.port = port;
            this.prefix = prefix;
            this.name = name;
            this.webdirConf = webdirConf;
            this.ipv6 = ipv6;
            this.stdio = stdio;
        }

        protected IStatus runSafe(IProgressMonitor monitor) {
            try {
                final AbstractShellCommand command = HgServeClient.getCommand(this.hgRoot, this.port, this.prefix, this.name, this.webdirConf, this.stdio, this.ipv6);
                SafeWorkspaceJob job = new SafeWorkspaceJob(String.valueOf(Messages.getString("HgServeClient.serverThread.name")) + command.getCommands().toString().replace(",", "")){

                    protected IStatus runSafe(IProgressMonitor m) {
                        try {
                            command.executeToBytes(Integer.MAX_VALUE, false);
                        }
                        catch (HgException e) {
                            MercurialEclipsePlugin.logError((Throwable)((Object)e));
                        }
                        return super.runSafe(m);
                    }
                };
                job.schedule();
                try {
                    while (!monitor.isCanceled()) {
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                command.terminate();
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
            }
            return super.runSafe(monitor);
        }
    }
}

